/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.sysdyn.SysdynResource;

public class ExpressionTypes {
    public static ExpressionType[] auxiliaryExpressions = new ExpressionType[]{ExpressionType.Auxiliary, ExpressionType.Parameter, ExpressionType.Constant, ExpressionType.Delay, ExpressionType.WithLookup};
    public static ExpressionType[] valveExpressions = new ExpressionType[]{ExpressionType.Auxiliary, ExpressionType.Parameter, ExpressionType.Constant, ExpressionType.Delay, ExpressionType.WithLookup};
    public static ExpressionType[] stockExpressions = new ExpressionType[]{ExpressionType.Stock};

    public static ExpressionType getExpressionType(final Resource expression) {
        try {
            return (ExpressionType)((Object)Simantics.getSession().syncRequest((Read)new Read<ExpressionType>(){

                public ExpressionType perform(ReadGraph graph) throws DatabaseException {
                    return ExpressionTypes.getExpressionType(graph, expression);
                }
            }));
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ExpressionType getExpressionType(ReadGraph graph, Resource expression) throws DatabaseException {
        ExpressionType et = null;
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        et = graph.isInstanceOf(expression, sr.NormalExpression) ? ExpressionType.Auxiliary : (graph.isInstanceOf(expression, sr.StockExpression) ? ExpressionType.Stock : (graph.isInstanceOf(expression, sr.ParameterExpression) ? ExpressionType.Parameter : (graph.isInstanceOf(expression, sr.ConstantExpression) ? ExpressionType.Constant : (graph.isInstanceOf(expression, sr.DelayExpression) ? ExpressionType.Delay : (graph.isInstanceOf(expression, sr.LookupExpression) ? ExpressionType.Lookup : (graph.isInstanceOf(expression, sr.WithLookupExpression) ? ExpressionType.WithLookup : ExpressionType.Empty))))));
        return et;
    }

    public static enum ExpressionType {
        Auxiliary,
        Parameter,
        Constant,
        Lookup,
        WithLookup,
        Stock,
        Delay,
        Empty;

    }
}

