/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.nodes;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.browsing.ui.common.node.DeleteException;
import org.simantics.browsing.ui.common.node.IDeletableNode;
import org.simantics.browsing.ui.common.node.IDropTargetNode;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.ExceptionUtils;

public abstract class AbstractChartNode<T>
extends AbstractNode<Resource>
implements IDropTargetNode,
IDeletableNode {
    public AbstractChartNode(Resource data) {
        super((Object)data);
    }

    public void drop(Object data) {
        IStructuredSelection selection = (IStructuredSelection)data;
        for (Object o : selection) {
            Variable v;
            if (!(o instanceof IAdaptable) || (v = (Variable)((IAdaptable)o).getAdapter(Variable.class)) == null) continue;
            this.addVariableToChart(v);
        }
    }

    protected abstract void addVariableToChart(Variable var1);

    public void delete() throws DeleteException {
        try {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException, CancelTransactionException {
                    graph.markUndoPoint();
                    String chartName = (String)graph.getRelatedValue2((Resource)AbstractChartNode.this.data, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
                    RemoverUtil.remove((WriteGraph)graph, (Resource)((Resource)AbstractChartNode.this.data));
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Removed chart '" + chartName + "' " + AbstractChartNode.this.data));
                }
            });
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
    }
}

