/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.nodeTypes;

import java.util.Collection;
import java.util.Collections;
import java.util.WeakHashMap;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.selection.WorkbenchSelectionElement;

public class ModuleSymbolNodeType
implements NodeType {
    private Resource resource;
    private Class<?> contentType;
    private static final WeakHashMap<Resource, ModuleSymbolNodeType> nodeTypeCache = new WeakHashMap();

    public ModuleSymbolNodeType(Resource resource) {
        this.resource = resource;
        this.contentType = Resource.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleSymbolNodeType create(Resource entityType) {
        WeakHashMap<Resource, ModuleSymbolNodeType> weakHashMap = nodeTypeCache;
        synchronized (weakHashMap) {
            ModuleSymbolNodeType result = nodeTypeCache.get(entityType);
            if (result == null) {
                result = new ModuleSymbolNodeType(entityType);
                nodeTypeCache.put(entityType, result);
            }
            return result;
        }
    }

    public NodeContext createNodeContext(ReadGraph graph, Object content) throws DatabaseException {
        if (this.contentType.isInstance(content)) {
            return NodeContextBuilder.buildWithData((NodeContext.ConstantKey[])KEY_SEQUENCE, (Object[])new Object[]{content, this});
        }
        return null;
    }

    public Class<?> getContentType() {
        return this.contentType;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleSymbolNodeType other = (ModuleSymbolNodeType)obj;
        return this.resource.equals(other.resource);
    }

    public boolean inherits(ReadGraph graph, NodeType superType) {
        return this.equals(superType);
    }

    public Collection<NodeType> getSuper(ReadGraph g) {
        return Collections.emptyList();
    }

    public String toString(ReadGraph graph) throws DatabaseException {
        return "(" + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.resource) + ")";
    }

    public WorkbenchSelectionElement getWorkbenchSelectionElement(NodeContext context) {
        return null;
    }
}

