/*
 * Decompiled with CFR 0.152.
 */
package winterwell.markdown.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import winterwell.markdown.Activator;

public class MarkdownPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREF_FOLDING = "Pref_Folding";
    public static final String PREF_WORD_WRAP = "Pref_WordWrap";
    public static final String PREF_TASK_TAGS = "Pref_TaskTagsOn";
    public static final String PREF_TASK_TAGS_DEFINED = "Pref_TaskTags";
    public static final String PREF_SECTION_NUMBERS = "Pref_SectionNumbers";
    public static final String PREF_MARKDOWN_COMMAND = "Pref_Markdown_Command";
    private static final String MARKDOWNJ = "(use built-in MarkdownJ converter)";
    public static final String PREF_DEFUALT = "Pref_Default";
    public static final String PREF_COMMENT = "Pref_Comment";
    public static final String PREF_HEADER = "Pref_Header";
    public static final String PREF_LINK = "Pref_Link";
    public static final String PREF_CODE = "Pref_Code";
    public static final String PREF_CODE_BG = "Pref_Code_Background";
    public static final String PREF_GITHUB_SYNTAX = "Pref_Github_Syntax";
    public static final String PREF_MULTIMARKDOWN_METADATA = "Pref_MultiMarkdown_Metadata";
    private static final RGB DEF_DEFAULT = new RGB(0, 0, 0);
    private static final RGB DEF_COMMENT = new RGB(128, 0, 0);
    private static final RGB DEF_HEADER = new RGB(0, 128, 0);
    private static final RGB DEF_LINK = new RGB(106, 131, 199);
    private static final RGB DEF_CODE = new RGB(0, 0, 0);
    private static final RGB DEF_CODE_BG = new RGB(244, 244, 244);

    public MarkdownPreferencePage() {
        super(1);
        IPreferenceStore pStore = Activator.getDefault().getPreferenceStore();
        MarkdownPreferencePage.setDefaultPreferences(pStore);
        this.setPreferenceStore(pStore);
        this.setDescription("Settings for the Markdown text editor. See also the general text editor preferences.");
    }

    public static void setDefaultPreferences(IPreferenceStore pStore) {
        pStore.setDefault(PREF_WORD_WRAP, false);
        pStore.setDefault(PREF_FOLDING, true);
        pStore.setDefault(PREF_TASK_TAGS, true);
        pStore.setDefault(PREF_TASK_TAGS_DEFINED, "TODO,FIXME,??");
        pStore.setDefault(PREF_MARKDOWN_COMMAND, MARKDOWNJ);
        pStore.setDefault(PREF_SECTION_NUMBERS, true);
        pStore.setDefault(PREF_GITHUB_SYNTAX, true);
        pStore.setDefault(PREF_MULTIMARKDOWN_METADATA, false);
        PreferenceConverter.setDefault((IPreferenceStore)pStore, (String)PREF_DEFUALT, (RGB)DEF_DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)pStore, (String)PREF_COMMENT, (RGB)DEF_COMMENT);
        PreferenceConverter.setDefault((IPreferenceStore)pStore, (String)PREF_HEADER, (RGB)DEF_HEADER);
        PreferenceConverter.setDefault((IPreferenceStore)pStore, (String)PREF_LINK, (RGB)DEF_LINK);
        PreferenceConverter.setDefault((IPreferenceStore)pStore, (String)PREF_CODE, (RGB)DEF_CODE);
        PreferenceConverter.setDefault((IPreferenceStore)pStore, (String)PREF_CODE_BG, (RGB)DEF_CODE_BG);
    }

    public void createFieldEditors() {
        BooleanFieldEditor fd = new BooleanFieldEditor(PREF_WORD_WRAP, "Soft word wrapping \r\nNote: may cause line numbers and related \r\nfunctionality to act a bit strangely", this.getFieldEditorParent());
        this.addField((FieldEditor)fd);
        fd = new BooleanFieldEditor(PREF_TASK_TAGS, "Manage tasks using task tags \r\nIf true, this will add and delete tags in sync with edits.", this.getFieldEditorParent());
        this.addField((FieldEditor)fd);
        StringFieldEditor tags = new StringFieldEditor(PREF_TASK_TAGS_DEFINED, "Task tags\nComma separated list of recognised task tags.", this.getFieldEditorParent());
        this.addField((FieldEditor)tags);
        fd = new BooleanFieldEditor(PREF_FOLDING, "Document folding, a.k.a. outline support", this.getFieldEditorParent());
        this.addField((FieldEditor)fd);
        StringFieldEditor cmd = new StringFieldEditor(PREF_MARKDOWN_COMMAND, "UNSTABLE: Command-line to run Markdown.\r\nThis should take in a file and output to std-out.\nLeave blank to use the built-in Java converter.", this.getFieldEditorParent());
        this.addField((FieldEditor)cmd);
        ColorFieldEditor def = new ColorFieldEditor(PREF_DEFUALT, "Default text", this.getFieldEditorParent());
        this.addField((FieldEditor)def);
        ColorFieldEditor com = new ColorFieldEditor(PREF_COMMENT, "Comment", this.getFieldEditorParent());
        this.addField((FieldEditor)com);
        ColorFieldEditor link = new ColorFieldEditor(PREF_LINK, "Link", this.getFieldEditorParent());
        this.addField((FieldEditor)link);
        ColorFieldEditor head = new ColorFieldEditor(PREF_HEADER, "Header and List indicator", this.getFieldEditorParent());
        this.addField((FieldEditor)head);
        ColorFieldEditor code = new ColorFieldEditor(PREF_CODE, "Code", this.getFieldEditorParent());
        this.addField((FieldEditor)code);
        ColorFieldEditor codeBg = new ColorFieldEditor(PREF_CODE_BG, "Code Background", this.getFieldEditorParent());
        this.addField((FieldEditor)codeBg);
        fd = new BooleanFieldEditor(PREF_GITHUB_SYNTAX, "Support Github Syntax", this.getFieldEditorParent());
        this.addField((FieldEditor)fd);
        fd = new BooleanFieldEditor(PREF_MULTIMARKDOWN_METADATA, "Support Multi-Markdown Metadata", this.getFieldEditorParent());
        this.addField((FieldEditor)fd);
    }

    public void init(IWorkbench workbench) {
    }

    public static boolean wordWrap() {
        IPreferenceStore pStore = Activator.getDefault().getPreferenceStore();
        if (!pStore.contains(PREF_WORD_WRAP)) {
            return false;
        }
        return pStore.getBoolean(PREF_WORD_WRAP);
    }
}

