/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.EditorAreaDropAdapter;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.WelcomeEditorInput;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.WorkbenchShutdownService;
import org.simantics.workbench.internal.Activator;
import org.simantics.workbench.internal.ApplicationUtil;
import org.simantics.workbench.internal.SimanticsWorkbenchActionBarAdvisor;
import org.simantics.workbench.internal.SimanticsWorkbenchAdvisor;

public class SimanticsWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final String WELCOME_EDITOR_ID = "org.eclipse.ui.internal.ide.dialogs.WelcomeEditor";
    protected SimanticsWorkbenchAdvisor wbAdvisor;
    protected boolean editorsAndIntrosOpened = false;
    protected IEditorPart lastActiveEditor = null;
    protected IPerspectiveDescriptor lastPerspective = null;
    protected IWorkbenchPage lastActivePage;
    protected String lastEditorTitle = "";
    private final IPropertyListener editorPropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            String newTitle;
            if (propId == 1 && SimanticsWorkbenchWindowAdvisor.this.lastActiveEditor != null && !SimanticsWorkbenchWindowAdvisor.this.lastEditorTitle.equals(newTitle = SimanticsWorkbenchWindowAdvisor.this.lastActiveEditor.getTitle())) {
                SimanticsWorkbenchWindowAdvisor.this.recomputeTitle();
            }
        }
    };
    private IAdaptable lastInput;
    private ActionFactory.IWorkbenchAction openPerspectiveAction;
    private IPropertyChangeListener propertyChangeListener;
    private volatile boolean allWindowShellsClosed = false;

    protected int perspectiveBarStyle() {
        return 8520000;
    }

    public SimanticsWorkbenchWindowAdvisor(SimanticsWorkbenchAdvisor wbAdvisor, IWorkbenchWindowConfigurer configurer) {
        super(configurer);
        this.wbAdvisor = wbAdvisor;
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new SimanticsWorkbenchActionBarAdvisor(configurer);
    }

    private IWorkbench getWorkbench() {
        return this.getWindowConfigurer().getWorkbenchConfigurer().getWorkbench();
    }

    public boolean preWindowShellClose() {
        AtomicBoolean saveAtExit;
        if (this.getWorkbench().getWorkbenchWindowCount() > 1) {
            return true;
        }
        if (this.allWindowShellsClosed) {
            return false;
        }
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean promptOnExit = store.getBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW");
        if (promptOnExit) {
            String productName = null;
            IProduct product = Platform.getProduct();
            if (product != null) {
                productName = product.getName();
            }
            String message = productName == null ? IDEWorkbenchMessages.PromptOnExitDialog_message0 : NLS.bind((String)IDEWorkbenchMessages.PromptOnExitDialog_message1, (Object)productName);
            MessageDialogWithToggle dlg = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getWindowConfigurer().getWindow().getShell(), (String)IDEWorkbenchMessages.PromptOnExitDialog_shellTitle, (String)message, (String)IDEWorkbenchMessages.PromptOnExitDialog_choice, (boolean)false, null, null);
            if (dlg.getReturnCode() != 0) {
                return false;
            }
            if (dlg.getToggleState()) {
                store.setValue("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", false);
                IDEWorkbenchPlugin.getDefault().savePluginPreferences();
            }
        }
        if (!ApplicationUtil.allowShutdown(saveAtExit = new AtomicBoolean(false))) {
            return false;
        }
        this.wbAdvisor.setSaveAtExit(saveAtExit.get());
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(WorkbenchShutdownService.class.getName());
        WorkbenchShutdownService shutdown = (WorkbenchShutdownService)context.getService(ref);
        shutdown.doShutdown();
        context.ungetService(ref);
        this.allWindowShellsClosed = true;
        return true;
    }

    static boolean promptOnExit(Shell parentShell) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean promptOnExit = store.getBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW");
        if (promptOnExit) {
            String message;
            MessageDialogWithToggle dlg;
            IWorkbenchWindow workbenchWindow;
            if (parentShell == null && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
                parentShell = workbenchWindow.getShell();
            }
            if (parentShell != null) {
                parentShell.setMinimized(false);
                parentShell.forceActive();
            }
            String productName = null;
            IProduct product = Platform.getProduct();
            if (product != null) {
                productName = product.getName();
            }
            if ((dlg = MessageDialogWithToggle.openOkCancelConfirm((Shell)parentShell, (String)IDEWorkbenchMessages.PromptOnExitDialog_shellTitle, (String)(message = productName == null ? IDEWorkbenchMessages.PromptOnExitDialog_message0 : NLS.bind((String)IDEWorkbenchMessages.PromptOnExitDialog_message1, (Object)productName)), (String)IDEWorkbenchMessages.PromptOnExitDialog_choice, (boolean)false, null, null)).getReturnCode() != 0) {
                return false;
            }
            if (dlg.getToggleState()) {
                store.setValue("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", false);
                IDEWorkbenchPlugin.getDefault().savePluginPreferences();
            }
        }
        return true;
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        boolean showProgressIndicator = !"false".equals(System.getProperty("org.simantics.workbench.application.showProgressIndicator", "true").toLowerCase());
        boolean showPerspectiveBar = !"false".equals(System.getProperty("org.simantics.workbench.application.showPerspectiveBar", "true").toLowerCase());
        configurer.setShowProgressIndicator(showProgressIndicator);
        configurer.setShowPerspectiveBar(showPerspectiveBar);
        configurer.addEditorAreaTransfer((Transfer)EditorInputTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)ResourceTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)FileTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)MarkerTransfer.getInstance());
        configurer.configureEditorAreaDropListener((DropTargetListener)new EditorAreaDropAdapter(configurer.getWindow()));
        this.hookTitleUpdateListeners(configurer);
    }

    private void hookTitleUpdateListeners(IWorkbenchWindowConfigurer configurer) {
        configurer.getWindow().addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
                SimanticsWorkbenchWindowAdvisor.this.updateTitle(false);
            }

            public void pageClosed(IWorkbenchPage page) {
                SimanticsWorkbenchWindowAdvisor.this.updateTitle(false);
            }

            public void pageOpened(IWorkbenchPage page) {
            }
        });
        configurer.getWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                SimanticsWorkbenchWindowAdvisor.this.updateTitle(false);
            }

            public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
                SimanticsWorkbenchWindowAdvisor.this.updateTitle(false);
            }

            public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                SimanticsWorkbenchWindowAdvisor.this.updateTitle(false);
            }
        });
        configurer.getWindow().getPartService().addPartListener(new IPartListener2(){

            public void partActivated(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference) {
                    SimanticsWorkbenchWindowAdvisor.this.updateTitle(false);
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference) {
                    SimanticsWorkbenchWindowAdvisor.this.updateTitle(false);
                }
            }

            public void partClosed(IWorkbenchPartReference ref) {
                SimanticsWorkbenchWindowAdvisor.this.updateTitle(false);
            }

            public void partDeactivated(IWorkbenchPartReference ref) {
            }

            public void partOpened(IWorkbenchPartReference ref) {
            }

            public void partHidden(IWorkbenchPartReference ref) {
                if (ref.getPart(false) == SimanticsWorkbenchWindowAdvisor.this.lastActiveEditor && SimanticsWorkbenchWindowAdvisor.this.lastActiveEditor != null) {
                    SimanticsWorkbenchWindowAdvisor.this.updateTitle(true);
                }
            }

            public void partVisible(IWorkbenchPartReference ref) {
                if (ref.getPart(false) == SimanticsWorkbenchWindowAdvisor.this.lastActiveEditor && SimanticsWorkbenchWindowAdvisor.this.lastActiveEditor != null) {
                    SimanticsWorkbenchWindowAdvisor.this.updateTitle(false);
                }
            }

            public void partInputChanged(IWorkbenchPartReference ref) {
            }
        });
        ISessionContextProvider provider = SimanticsUI.getSessionContextProvider((Object)configurer.getWindow());
        provider.addContextChangedListener(new ISessionContextChangedListener(){

            public void sessionContextChanged(SessionContextChangedEvent event) {
                IWorkbenchWindowConfigurer configurer = SimanticsWorkbenchWindowAdvisor.this.getWindowConfigurer();
                IWorkbenchWindow window = configurer.getWindow();
                if (window == null) {
                    return;
                }
                Shell shell = window.getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SimanticsWorkbenchWindowAdvisor.this.updateTitle(true);
                    }
                });
            }
        });
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("WORKSPACE_NAME".equals(property) || "SHOW_LOCATION".equals(property)) {
                    SimanticsWorkbenchWindowAdvisor.this.lastActivePage = null;
                    SimanticsWorkbenchWindowAdvisor.this.updateTitle(false);
                }
            }
        };
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    protected String computeTitle() {
        String workspaceName;
        String workspaceLocation;
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchPage currentPage = configurer.getWindow().getActivePage();
        IEditorPart activeEditor = null;
        if (currentPage != null) {
            activeEditor = this.lastActiveEditor;
        }
        String title = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            title = product.getName();
        }
        if (title == null) {
            title = "";
        }
        if (currentPage != null) {
            boolean excludePerspectiveFromTitle;
            if (activeEditor != null) {
                this.lastEditorTitle = activeEditor.getTitleToolTip();
                title = NLS.bind((String)"{0} - {1}", (Object)this.lastEditorTitle, (Object)title);
            }
            if (!(excludePerspectiveFromTitle = "true".equals(System.getProperty("org.simantics.workbench.application.excludePerspectiveFromTitle", "false").toLowerCase()))) {
                IAdaptable input;
                IPerspectiveDescriptor persp = currentPage.getPerspective();
                String label = "";
                if (persp != null) {
                    label = persp.getLabel();
                }
                if ((input = currentPage.getInput()) != null && !input.equals(this.wbAdvisor.getDefaultPageInput())) {
                    label = currentPage.getLabel();
                }
                if (label != null && !label.equals("")) {
                    title = NLS.bind((String)"{0} - {1}", (Object)label, (Object)title);
                }
            }
        }
        if ((workspaceLocation = this.wbAdvisor.getWorkspaceLocation()) != null) {
            title = NLS.bind((String)"{0} - {1}", (Object)title, (Object)workspaceLocation);
        }
        if ((workspaceName = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("WORKSPACE_NAME")) != null && workspaceName.length() > 0) {
            title = NLS.bind((String)"{0} - {1}", (Object)workspaceName, (Object)title);
        }
        return title;
    }

    private void recomputeTitle() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        String oldTitle = configurer.getTitle();
        String newTitle = this.computeTitle();
        if (!newTitle.equals(oldTitle)) {
            configurer.setTitle(newTitle);
        }
    }

    private void updateTitle(boolean force) {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchWindow window = configurer.getWindow();
        IEditorPart activeEditor = null;
        IWorkbenchPage currentPage = window.getActivePage();
        IPerspectiveDescriptor persp = null;
        IAdaptable input = null;
        if (currentPage != null) {
            activeEditor = currentPage.getActiveEditor();
            persp = currentPage.getPerspective();
            input = currentPage.getInput();
        }
        if (!force && activeEditor == this.lastActiveEditor && currentPage == this.lastActivePage && persp == this.lastPerspective && input == this.lastInput) {
            return;
        }
        if (this.lastActiveEditor != null) {
            this.lastActiveEditor.removePropertyListener(this.editorPropertyListener);
        }
        this.lastActiveEditor = activeEditor;
        this.lastActivePage = currentPage;
        this.lastPerspective = persp;
        this.lastInput = input;
        if (activeEditor != null) {
            activeEditor.addPropertyListener(this.editorPropertyListener);
        }
        this.recomputeTitle();
    }

    public void postWindowRestore() throws WorkbenchException {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchWindow window = configurer.getWindow();
        int index = this.getWorkbench().getWorkbenchWindowCount() - 1;
        AboutInfo[] welcomePerspectiveInfos = this.wbAdvisor.getWelcomePerspectiveInfos();
        if (index >= 0 && welcomePerspectiveInfos != null && index < welcomePerspectiveInfos.length) {
            IWorkbenchPage[] pages;
            IWorkbenchPage page = window.getActivePage();
            if (page == null && (pages = window.getPages()) != null && pages.length > 0) {
                page = pages[0];
            }
            String perspectiveId = welcomePerspectiveInfos[index].getWelcomePerspectiveId();
            if (page == null) {
                IAdaptable root = this.wbAdvisor.getDefaultPageInput();
                page = window.openPage(perspectiveId, root);
            } else {
                IPerspectiveRegistry reg = this.getWorkbench().getPerspectiveRegistry();
                IPerspectiveDescriptor desc = reg.findPerspectiveWithId(perspectiveId);
                if (desc != null) {
                    page.setPerspective(desc);
                }
            }
            window.setActivePage(page);
            page.openEditor((IEditorInput)new WelcomeEditorInput(welcomePerspectiveInfos[index]), WELCOME_EDITOR_ID, true);
        }
    }

    public void openIntro() {
        if (this.editorsAndIntrosOpened) {
            return;
        }
        this.editorsAndIntrosOpened = true;
        if (this.wbAdvisor.hasIntro()) {
            super.openIntro();
        } else {
            this.openWelcomeEditors(this.getWindowConfigurer().getWindow());
            IDEWorkbenchPlugin.getDefault().savePluginPreferences();
        }
    }

    private void openWelcomeEditors(IWorkbenchWindow window) {
        if (IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("WELCOME_DIALOG")) {
            IProduct product = Platform.getProduct();
            if (product == null) {
                return;
            }
            AboutInfo productInfo = new AboutInfo(product);
            URL url = productInfo.getWelcomePageURL();
            if (url == null) {
                return;
            }
            IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue("WELCOME_DIALOG", false);
            this.openWelcomeEditor(window, new WelcomeEditorInput(productInfo), null);
        } else {
            ArrayList<AboutInfo> welcomeFeatures = new ArrayList<AboutInfo>();
            for (Map.Entry<String, AboutInfo> entry : this.wbAdvisor.getNewlyAddedBundleGroups().entrySet()) {
                Bundle bundle;
                AboutInfo info = entry.getValue();
                if (info == null || info.getWelcomePageURL() == null) continue;
                welcomeFeatures.add(info);
                String pi = info.getBrandingBundleId();
                if (pi == null || (bundle = Platform.getBundle((String)pi)) == null) continue;
                try {
                    bundle.start(1);
                }
                catch (BundleException exception) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.simantics.workbench", "Failed to load feature", (Throwable)exception));
                }
            }
            int wCount = this.getWorkbench().getWorkbenchWindowCount();
            int i = 0;
            while (i < welcomeFeatures.size()) {
                AboutInfo newInfo = (AboutInfo)welcomeFeatures.get(i);
                String id = newInfo.getWelcomePerspectiveId();
                if (id == null || i >= wCount) {
                    this.openWelcomeEditor(window, new WelcomeEditorInput(newInfo), id);
                }
                ++i;
            }
        }
    }

    private void openWelcomeEditor(IWorkbenchWindow window, WelcomeEditorInput input, String perspectiveId) {
        if (this.getWorkbench().getWorkbenchWindowCount() == 0) {
            return;
        }
        IWorkbenchWindow win = window;
        if (perspectiveId != null) {
            try {
                win = this.getWorkbench().openWorkbenchWindow(perspectiveId, this.wbAdvisor.getDefaultPageInput());
                if (win == null) {
                    win = window;
                }
            }
            catch (WorkbenchException e) {
                IDEWorkbenchPlugin.log((String)"Error opening window with welcome perspective.", (IStatus)e.getStatus());
                return;
            }
        }
        if (win == null) {
            win = this.getWorkbench().getWorkbenchWindows()[0];
        }
        IWorkbenchPage page = win.getActivePage();
        String id = perspectiveId;
        if (id == null) {
            id = this.getWorkbench().getPerspectiveRegistry().getDefaultPerspective();
        }
        if (page == null) {
            try {
                page = win.openPage(id, this.wbAdvisor.getDefaultPageInput());
            }
            catch (WorkbenchException e) {
                ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.Problems_Opening_Page, (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
        if (page == null) {
            return;
        }
        if (page.getPerspective() == null) {
            try {
                page = this.getWorkbench().showPerspective(id, win);
            }
            catch (WorkbenchException e) {
                ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogTitle, (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogMessage, (IStatus)e.getStatus());
                return;
            }
        }
        page.setEditorAreaVisible(true);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.activate((IWorkbenchPart)editor);
            return;
        }
        try {
            page.openEditor((IEditorInput)input, WELCOME_EDITOR_ID);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogTitle, (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogMessage, (IStatus)e.getStatus());
        }
    }

    public Control createEmptyWindowContents(Composite parent) {
        IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Display display = composite.getDisplay();
        Color bgCol = display.getSystemColor(34);
        composite.setBackground(bgCol);
        Label label = new Label(composite, 64);
        label.setForeground(display.getSystemColor(33));
        label.setBackground(bgCol);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        String msg = IDEWorkbenchMessages.IDEWorkbenchAdvisor_noPerspective;
        label.setText(msg);
        ToolBarManager toolBarManager = new ToolBarManager();
        this.openPerspectiveAction = ActionFactory.OPEN_PERSPECTIVE_DIALOG.create(window);
        toolBarManager.add((IAction)this.openPerspectiveAction);
        ToolBar toolBar = toolBarManager.createControl(composite);
        toolBar.setBackground(bgCol);
        return composite;
    }

    public void dispose() {
        if (this.propertyChangeListener != null) {
            IDEWorkbenchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        if (this.openPerspectiveAction != null) {
            this.openPerspectiveAction.dispose();
            this.openPerspectiveAction = null;
        }
        super.dispose();
    }
}

