package org.simantics.workbench.search;

import java.util.ArrayList;
import java.util.List;

import org.simantics.databoard.util.URIStringUtils;

/**
 * Search Result for Name and Type queries.
 * 
 * Similar to NameAndTypeRow, but omits the type of result 
 * 
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class NameRow implements SearchResultRow {
	
	public static final List<SearchResultColumn> columns;
	
	static {
		columns = new ArrayList<SearchResultColumn>();
		columns.add(new SearchResultColumn("Name"));
		columns.add(new SearchResultColumn("Part Of"));
	}
	
	public NamedResource             resource;
    public NamedResource             parent;

    public NamedResource getResource() {
        return resource;
    }

    public NamedResource getParent() {
        return parent;
    }
    
    @Override
    public String getContent(int column) {
    	switch (column) {
		case 0:
			return "<a class=\"small\" href=\"resource:"+ resource.getResource() +"\"" + (resource.getUri() == null ? "" : " title=\""+URIStringUtils.unescape( resource.getUri() ))+"\">"+StringUtil.escape(resource.getName())+"</a>";
		case 1:
			if (parent != null)
				return "<a class=\"small\" href=\"resource:"+ parent.getResource() +"\"" + (parent.getUri() == null ? "" : " title=\""+URIStringUtils.unescape( parent.getUri() ))+"\">"+StringUtil.escape(parent.getName())+"</a>";
			return "";
		default:
			return "";
		}
    }
}
