package org.simantics.views.swt.client.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.StatePersistor;
import org.simantics.browsing.ui.swt.PassThruInputSource;
import org.simantics.browsing.ui.swt.widgets.ModelBrowser;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.views.ViewUtils.ColumnBean;
import org.simantics.views.ViewUtils.LayoutBean;
import org.simantics.views.swt.client.base.SWTViewUtils;
import org.simantics.views.swt.client.base.SingleSWTViewNode;

public class SWTExplorer extends SingleSWTViewNode<ModelBrowser> {
	
	private static final long serialVersionUID = 7932335224632082902L;
	
	public LayoutBean layout;
	public String browseContext;
	public String contextMenuId;
	public String uiContext;
	public Function1<Object, Boolean> selectionListener;
	public Object input;
	public List<ColumnBean> columns;
	public List<ColumnBean> editingColumns;
	public Boolean columnsVisible;
	public Boolean displayFilter;
	public Boolean publishSelection;
	public Boolean useNodeBrowseContexts;
	public Boolean useNodeActionContexts;
	public StatePersistor persistor;
	
	public ISelection lastSelection;
	
	@Override
	public void createControls(Composite parent) {

		if(browseContext == null) return;
		
		final IWorkbenchSite site = getSite();

		Map<String, Object> args = new HashMap<String, Object>();
		args.put("displaySelectors", Boolean.FALSE);
		args.put("displayFilter", displayFilter != null ? displayFilter : Boolean.FALSE);
		if(useNodeBrowseContexts != null && useNodeBrowseContexts) {
			args.put("useNodeBrowseContexts", true);
		}
		if(useNodeActionContexts != null && useNodeActionContexts) {
			args.put("useNodeActionContexts", true);
		}

		control = new ModelBrowser(Collections.singleton(browseContext), args, site, parent, new WidgetSupportImpl(), style);
		control.setContextMenuId(contextMenuId);
		if (uiContext != null) {
			control.setUiContexts(Collections.singleton(uiContext));
		}
		
		control.setStatePersistor(persistor);
		
		control.finish();

		setProperties();
		
		control.setInputSource(PassThruInputSource.INSTANCE);

		ISelectionProvider sp = (ISelectionProvider)control.getExplorer().getAdapter(ISelectionProvider.class);
		sp.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				if (site != null) {
					ISelectionProvider sp = site.getSelectionProvider();
					if (sp != null) {
						sp.setSelection(event.getSelection());
					}
				}
			}
			
		});
		
		IPostSelectionProvider psp = (IPostSelectionProvider)control.getExplorer().getAdapter(IPostSelectionProvider.class);
		psp.addPostSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				
//				ISelection selection = (ISelection)control.getExplorer().getWidgetSelection();
				if (site != null) {
					ISelectionProvider sp = site.getSelectionProvider();
					if (sp != null) {
						sp.setSelection(event.getSelection());
					}
				}
				
			}
			
		});
		
		control.addListenerToControl(SWT.Selection, new Listener() {

			@Override
			public void handleEvent(Event event) {
				
				if(selectionListener != null)
					selectionListener.apply(event);
				
				ISelection selection = (ISelection)control.getExplorer().getWidgetSelection();
				// [Tuukka@2012-04-08] Disabled this because it was causing
				// horrible selection feedback effects in the Model Browser
				// view that is using it. It causes the browser to react to
				// external selections which were initially published as its own
				// with a delay.
				//System.out.println("selection: " + selection);
//				if(publishSelection != null && publishSelection) {
//					if (site != null) {
//						ISelectionProvider sp = site.getSelectionProvider();
//						if (sp != null) {
//							sp.setSelection(selection);
//						}
//					}
//				}
				
				propertyCallback.apply("selection", selection);
				
				lastSelection = selection;
				
			}
			
		});
			
	}

	public void synchronizeColumnsVisible(Boolean columnsVisible) {
		if(columnsVisible != null) control.setColumnsVisible(columnsVisible);
	}
	
	public void synchronizeDisplayFilter(Boolean displayFilter) {
//		if(displayFilter != null) control.setColumnsVisible(displayFilter);
	}

	public void synchronizePublishSelection(Boolean publishSelection) {
	}

	public void synchronizeInput(Object input) {
		if(input != null) control.setInput(input, false);
	}
	
	public void synchronizeBrowseContext(String browseContext) {
	}
	
	public void synchronizeContextMenuId(String contextMenuId) {
	}

	public void synchronizeSelectionListener(Function1<Object, Boolean> selectionListener) {
	}

	public void synchronizePersistor(StatePersistor persistor) {
	}

	public void synchronizeColumns(ArrayList<ColumnBean> columns) {
		if(columns != null) {
			Column[] cols = new Column[columns.size()];
			for(int i=0;i<columns.size();i++) cols[i] = SWTViewUtils.toColumn(columns.get(i));
			control.setColumns(cols);
		}
	}

	public void synchronizeEditingColumns(ArrayList<ColumnBean> columns) {
		if(columns != null) {
			String[] ecs = new String[columns.size()];
			for(int i=0;i<columns.size();i++) ecs[i] = columns.get(i).key;
			control.setEditingColumn(ecs);
		}
	}

	final public void synchronizeLayout(LayoutBean layout) {
	}
	
}
