/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.validators;

import org.eclipse.jface.dialogs.IInputValidator;

public class RangeValidator
implements IInputValidator {
    final long minValue;
    final long maxValue;

    public RangeValidator(long minValue, long maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public String isValid(String newText) {
        try {
            long value = new Long(newText);
            if (value < this.minValue) {
                return "Value must be at least or over " + this.minValue;
            }
            if (value > this.maxValue) {
                return "Value must be at most " + this.maxValue;
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return "\"" + newText + "\" is not an integer value";
        }
    }
}

