/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.internal.awt;

import java.awt.EventQueue;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.utils.ui.internal.awt.AwtDialogListener;
import org.simantics.utils.ui.internal.awt.Platform;
import org.simantics.utils.ui.internal.awt.SwtInputBlocker;

public final class AwtEnvironment {
    private static final String GTK_LOOK_AND_FEEL_NAME = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    private static AwtEnvironment instance = null;
    private static boolean isLookAndFeelInitialized = false;
    private final Display display;
    private final AwtDialogListener dialogListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AwtEnvironment getInstance(Display display) {
        if (display == null) {
            SWT.error((int)4);
        }
        if (instance != null && !display.equals(AwtEnvironment.instance.display)) {
            throw new UnsupportedOperationException("Multiple displays not supported");
        }
        Class<AwtEnvironment> clazz = AwtEnvironment.class;
        synchronized (AwtEnvironment.class) {
            if (instance == null) {
                instance = new AwtEnvironment(display);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private AwtEnvironment(Display display) {
        assert (display != null);
        System.setProperty("sun.awt.noerasebackground", "true");
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AwtEnvironment.this.setSystemLookAndFeel();
                }
            });
        }
        catch (InterruptedException e) {
            SWT.error((int)46, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            SWT.error((int)46, (Throwable)e.getCause());
        }
        this.display = display;
        this.dialogListener = new AwtDialogListener(display);
    }

    public void invokeAndBlockSwt(final Runnable runnable) {
        assert (this.display != null);
        if (runnable == null) {
            SWT.error((int)4);
        }
        if (this.display != Display.getCurrent()) {
            SWT.error((int)22);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    AwtEnvironment.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SwtInputBlocker.unblock();
                        }
                    });
                    throw throwable;
                }
                AwtEnvironment.this.display.asyncExec(new /* invalid duplicate definition of identical inner class */);
            }
        });
        SwtInputBlocker.block();
    }

    public Frame createDialogParentFrame() {
        Shell parent;
        if (this.display != Display.getCurrent()) {
            SWT.error((int)22);
        }
        if ((parent = this.display.getActiveShell()) == null) {
            throw new IllegalStateException("No Active Shell");
        }
        return this.createDialogParentFrame(parent);
    }

    public Frame createDialogParentFrame(Shell parent) {
        if (parent == null) {
            SWT.error((int)4);
        }
        if (this.display != Display.getCurrent()) {
            SWT.error((int)22);
        }
        Shell shell = new Shell(parent);
        shell.setVisible(false);
        Composite composite = new Composite((Composite)shell, 0x1000000);
        return SWT_AWT.new_Frame((Composite)composite);
    }

    Shell getShell() {
        Shell[] allShells;
        Shell shell = this.display.getActiveShell();
        if (shell == null && (allShells = this.display.getShells()).length > 0) {
            shell = allShells[0];
        }
        return shell;
    }

    void requestAwtDialogFocus() {
        assert (this.dialogListener != null);
        this.dialogListener.requestFocus();
    }

    private void setSystemLookAndFeel() {
        assert (EventQueue.isDispatchThread());
        if (!isLookAndFeelInitialized) {
            isLookAndFeelInitialized = true;
            try {
                String systemLaf = UIManager.getSystemLookAndFeelClassName();
                String xplatLaf = UIManager.getCrossPlatformLookAndFeelClassName();
                if (xplatLaf.equals(systemLaf) && Platform.isGtk()) {
                    systemLaf = GTK_LOOK_AND_FEEL_NAME;
                }
                UIManager.setLookAndFeel(systemLaf);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (UnsupportedLookAndFeelException e) {
                e.printStackTrace();
            }
        }
    }

    static void reset() {
        instance = null;
    }
}

