/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.gfx.rasterize;

import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.ImageData;
import org.simantics.utils.ui.gfx.rasterize.RasterJob;
import org.simantics.utils.ui.gfx.rasterize.RasterJobStatus;

public class LazyRasterizer {
    static RasterizeJob job;

    public static void addJob(RasterJob job) {
        LazyRasterizer.getJob().addJob(job);
    }

    public static void addAsFirstJob(RasterJob job) {
        LazyRasterizer.getJob().addAsFirstJob(job);
    }

    public static void removeJob(RasterJob job) {
        LazyRasterizer.getJob().removeJob(job);
    }

    static synchronized RasterizeJob getJob() {
        if (job == null) {
            job = new RasterizeJob();
        }
        return job;
    }

    static class RasterizeJob
    extends Job {
        LinkedList<RasterJob> queue = new LinkedList();
        private boolean isRunning;

        public RasterizeJob() {
            super("Rasterize Job");
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.setThread(Thread.currentThread());
            int taskLeft = 10000;
            this.isRunning = true;
            monitor.beginTask("Rasterizing", taskLeft);
            try {
                RasterJob job = this.pullNextJob();
                do {
                    if (monitor.isCanceled()) {
                        this.cancel();
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    if (job != null) {
                        try {
                            monitor.subTask(job.raster.toString());
                            ImageData id = job.raster.rasterize(job.width, job.height);
                            job.listener.rasterizationComplete(job, id);
                        }
                        catch (Exception e) {
                            job.listener.rasterizationFailed(job, e);
                        }
                        int jobsLeft = this.jobsLeft();
                        double workLeft = jobsLeft == 0 ? (double)taskLeft : (double)taskLeft / (double)this.jobsLeft();
                        int worked = (int)workLeft;
                        monitor.worked(worked);
                        taskLeft -= worked;
                    }
                    monitor.subTask("");
                } while ((job = this.pullNextJob()) != null);
                this.isRunning = false;
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        protected synchronized int jobsLeft() {
            return this.queue.size();
        }

        protected synchronized RasterJob pullNextJob() {
            if (this.queue.isEmpty()) {
                return null;
            }
            return this.queue.removeFirst();
        }

        public synchronized void clear() {
            RasterJob[] jobs;
            RasterJob[] rasterJobArray = jobs = this.queue.toArray(new RasterJob[0]);
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                RasterJob j = rasterJobArray[n2];
                this.removeJob(j);
                ++n2;
            }
        }

        public synchronized void addJob(RasterJob job) {
            this.queue.addLast(job);
            job.status = RasterJobStatus.QUEUED;
            this.schedule();
        }

        public synchronized void addAsFirstJob(RasterJob job) {
            this.queue.addFirst(job);
            job.status = RasterJobStatus.QUEUED;
            this.schedule();
        }

        public synchronized boolean removeJob(RasterJob job) {
            if (this.queue.remove(job)) {
                job.status = RasterJobStatus.COMPLETE;
                job.listener.rasterizationCanceled(job);
                return true;
            }
            return false;
        }
    }
}

