/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui;

import java.awt.Dimension;
import java.awt.Frame;
import java.util.function.Supplier;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.SWTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialFrameSizeFixListener
extends ControlAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitialFrameSizeFixListener.class);
    private Control control;
    private Supplier<Frame> frameProvider;

    public InitialFrameSizeFixListener(Control listenedControl, Supplier<Frame> frameProvider) {
        this.control = listenedControl;
        this.frameProvider = frameProvider;
        this.control.addControlListener((ControlListener)this);
    }

    private static boolean needToFixDimensions(Point swtSize, Dimension awtSize) {
        Point p = swtSize;
        Dimension d = awtSize;
        return p.x > 0 && d.width == 0 || p.y > 0 && d.height == 0;
    }

    public void controlResized(ControlEvent e) {
        assert (e != null);
        assert (Display.getCurrent() != null);
        if (this.frameProvider == null) {
            return;
        }
        Frame f = this.frameProvider.get();
        if (f == null) {
            return;
        }
        Composite c = (Composite)e.widget;
        Point dsp = c.getSize();
        if (dsp.x == 0 || dsp.y == 0) {
            return;
        }
        Point p = DPIUtil.autoScaleUp((Point)dsp);
        Dimension d = f.getSize();
        LOGGER.trace("{}: PHASE 1: {} vs. {}", new Object[]{this, p, d});
        if (InitialFrameSizeFixListener.needToFixDimensions(p, d)) {
            ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), () -> {
                Dimension d2 = f.getSize();
                LOGGER.trace("{}: PHASE 2: {} vs. {}", new Object[]{this, p, d2});
                if (InitialFrameSizeFixListener.needToFixDimensions(p, d2)) {
                    LOGGER.trace("{}: PHASE 3: forcefully fix AWT Frame size to {} from {}", new Object[]{this, p, d2});
                    f.setSize(point.x, point.y);
                    SWTUtils.asyncExec((Widget)this.control, this::removeListener);
                }
            });
        } else {
            this.removeListener();
        }
    }

    private void removeListener() {
        if (!this.control.isDisposed()) {
            this.control.removeControlListener((ControlListener)this);
            LOGGER.trace("{}: REMOVE LISTENER", (Object)this);
        }
    }
}

