/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * Created on 5.10.2005
 * @author Toni Kalajainen 
 */
package org.simantics.utils.ui.jface;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/**
 * JFace Action -> SWT's MenuItem adapter.
 * <p>
 * So you have a SWT's MainMenu and you want to add Actions and 
 * for some reason you can't use JFace MenuManager. 
 * This adapter "converts" Actions into MenuItems.
 */
public class ActionMenuItemAdapter implements SelectionListener, IPropertyChangeListener {

    private final Action action;
    private final MenuItem menuitem;
    
    public static MenuItem adapt(Action action, Menu parent, int style, int index) {
        int _style = _getActionStyle(action) | style;
        MenuItem mi = new MenuItem(parent, _style, index);
        new ActionMenuItemAdapter(action, mi);
        return mi;
    }
    
    public static MenuItem adapt(Action action, Menu parent, int style) {
        int _style = _getActionStyle(action) | style;
        MenuItem mi = new MenuItem(parent, _style);
        new ActionMenuItemAdapter(action, mi);
        return mi;
    }
    
    private ActionMenuItemAdapter(Action action, MenuItem menuitem) {
        this.menuitem = menuitem;
        this.action = action;
        
        menuitem.setText(action.getText());
        if (action.getImageDescriptor() != null)
            menuitem.setImage(action.getImageDescriptor().createImage());
        menuitem.setSelection(action.isChecked());
        menuitem.addSelectionListener(this);
        action.addPropertyChangeListener(this);
        menuitem.addDisposeListener(new DisposeListener() {
            public void widgetDisposed(DisposeEvent e) {
                ActionMenuItemAdapter.this.action.removePropertyChangeListener(ActionMenuItemAdapter.this);
                ActionMenuItemAdapter.this.menuitem.removeDisposeListener(this);
            }});
    }
        

    private static int _getActionStyle(Action action) {
        int style = SWT.PUSH;
        if ((action.getStyle() & Action.AS_CHECK_BOX) > 0)
            style = SWT.CHECK;
        if ((action.getStyle() & Action.AS_RADIO_BUTTON) > 0)
            style = SWT.RADIO;
        return style;
    }

    public void widgetSelected(SelectionEvent e) {        
        action.run();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Action getAction() {
        return action;
    }

    public void propertyChange(PropertyChangeEvent event) {
        menuitem.setSelection(action.isChecked());
    }

}
