/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * 25.1.2007
 */
package org.simantics.utils.ui.gfx.rasterize;

/**
 * RasterJob
 * @author Toni Kalajainen
 */
public class RasterJob {

    public final IRasterizable raster;
    public final int width;
    public final int height;
    public final IRasterizationListener listener;
    RasterJobStatus status = RasterJobStatus.UNUSED;
    
    public RasterJob(IRasterizable raster, int width, int height, IRasterizationListener listener)
    {
        assert(raster!=null);
        assert(listener!=null);
        this.raster = raster;
        this.width = width;
        this.height = height;
        this.listener = listener;
    }
    
    public RasterJobStatus getStatus()
    {
        return status;
    }
    
}
