/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.gfx.clipboard.headers;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;


/**
 * WIN32 API BITMAPINFOHEADER
 * 
 * @see http://msdn.microsoft.com/library/default.asp?url=/library/en-us/gdi/bitmaps_1rw2.asp
 * @see org.eclipse.swt.internal.win32.BITMAPINFOHEADER
 * @author Marko Luukkainen
 *
 */
@SuppressWarnings("restriction")
public class BitmapInfoHeader {
    public int biSize;
    public int biWidth;
    public int biHeight;
    public short biPlanes;
    public short biBitCount;
    public int biCompression;
    public int biSizeImage;
    public int biXPelsPerMeter;
    public int biYPelsPerMeter;
    public int biClrUsed;
    public int biClrImportant;
    public static final int sizeof = 40;   
    
    public byte[] getBytes() {
        byte [] array = new byte[sizeof];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(biSize);
        buffer.putInt(biWidth);
        buffer.putInt(biHeight);
        buffer.putShort(biPlanes);
        buffer.putShort(biBitCount);
        buffer.putInt(biCompression);
        buffer.putInt(biSizeImage);
        buffer.putInt(biXPelsPerMeter);
        buffer.putInt(biYPelsPerMeter);
        buffer.putInt(biClrUsed);
        buffer.putInt(biClrImportant); 
        return array;
    }
    
    public void setBytes(byte[] array) {
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        biSize = buffer.getInt();
        biWidth = buffer.getInt();
        biHeight = buffer.getInt();
        biPlanes = buffer.getShort();
        biBitCount = buffer.getShort();
        biCompression = buffer.getInt();
        biSizeImage = buffer.getInt();
        biXPelsPerMeter = buffer.getInt();
        biYPelsPerMeter = buffer.getInt();
        biClrUsed = buffer.getInt();
        biClrImportant = buffer.getInt();
    }
    
}
