/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * 10.10.2006
 */
package org.simantics.utils.ui.gfx;

import java.awt.Dimension;


/**
 * PixelDimension
 * 
 * @author Toni Kalajainen
 */
public class PixelDimension {

    public final int width;

    public final int height;

    public PixelDimension(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public PixelDimension(PixelDimension d) {
        this(d.width, d.height);
    }
    
    public PixelDimension(Dimension d) {
        this(d.width, d.height);
    }

    public int getHeight() {
        return height;
    }

    public int getWidth() {
        return width;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PixelDimension))
            return false;
        PixelDimension d = (PixelDimension) obj;
        return (width == d.width) && (height == d.height);
    }

    public int hashCode() {
        int sum = width+height;
        return sum*(sum+1)/2 + width;
    }
    
    @Override
    public String toString() {
        return "PixelDimension [w=" + width + ", h=" + height + "]";
    }    
    
    /**
     * returns aspect ratio (width / height)
     * @return returns aspect ratio (width / height)
     */
    public double getAspectRatio()
    {
        return (double)width / (double)height;
    }
    
}
