/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.action;

import org.eclipse.jface.action.IAction;

/**
 * @author Tuukka Lehtonen
 */
public class PriorityActionAdapter extends PriorityAction {

    private IAction handler;
    
    /**
     * @param handler
     * @throws NullPointerException for null handlers
     */
    public PriorityActionAdapter(IAction handler) {
        this(IPriorityAction.NORMAL, handler);
    }

    /**
     * @param priority
     * @param handler
     * @throws NullPointerException for null handlers
     */
    public PriorityActionAdapter(int priority, IAction handler) {
        super(priority, handler.getText(), handler.getStyle());
        this.handler = handler;

        setText(handler.getText());
        setImageDescriptor(handler.getImageDescriptor());
    }

    @Override
    public void run() {
        if (handler != null) {
            handler.run();
        }
    }
}
