/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * 4.7.2006
 */
package org.simantics.utils.ui;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;

/**
 * LayoutUtils
 * 
 * @author Toni Kalajainen
 */
public class LayoutUtils {

    public static GridLayout createNoBorderGridLayout(int numColumns) {
        return createNoBorderGridLayout(numColumns, true);
    }

    public static GridLayout createNoBorderGridLayout(int numColumns, boolean makeColumnsEqualWidth) {
        GridLayout gl = new GridLayout(numColumns, makeColumnsEqualWidth);
        gl.marginBottom = 0;
        gl.marginLeft = 0;
        gl.marginTop = 0;
        gl.marginRight = 0;
        gl.marginHeight = 0;
        gl.marginTop = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        return gl;
    }

    public static GridData createNoBorderGridData() {
        return new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.VERTICAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL
                | GridData.GRAB_VERTICAL);
    }

    public static GridData createNoBorderGridData(int numColumns) {
        GridData gd = new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.VERTICAL_ALIGN_FILL
                | GridData.GRAB_HORIZONTAL | GridData.GRAB_VERTICAL);
        gd.horizontalSpan = numColumns;
        return gd;
    }

}
