/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.utils.threads.Executable;
import org.simantics.utils.threads.ThreadUtils;

public class ExecutorWorker {
    private static volatile ExecutorWorker instance;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final ThreadGroup threadGroup = new ThreadGroup("ExecutorWorker-Group");
    private ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(1, r -> {
        Thread t = new Thread(this.threadGroup, r, "ExecutorWorker-" + this.counter.incrementAndGet());
        if (!t.isDaemon()) {
            t.setDaemon(true);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorWorker getInstance() {
        if (instance != null) return instance;
        Class<ExecutorWorker> clazz = ExecutorWorker.class;
        synchronized (ExecutorWorker.class) {
            if (instance != null) return instance;
            instance = new ExecutorWorker();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ExecutorWorker() {
    }

    public synchronized ScheduledFuture<Object> timerExec(Executable executable, int delay) {
        Callable<Object> c = () -> {
            ThreadUtils.asyncExec(executable.threadAccess, executable.runnable);
            return null;
        };
        return this.pool.schedule(c, (long)delay, TimeUnit.MILLISECONDS);
    }

    private void shutdownThis() {
        ScheduledThreadPoolExecutor e = this.pool;
        if (e != null) {
            this.pool = null;
            ThreadUtils.shutdownAndAwaitTermination(e, 1000L);
        }
    }

    public static synchronized void shutdown() {
        ExecutorWorker i = instance;
        if (i != null) {
            instance = null;
            i.shutdownThis();
        }
    }
}

