/*******************************************************************************
 * Copyright (c) 2007- VTT Technical Research Centre of Finland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * Created on Jan 21, 2005
 * 
 * Copyright Toni Kalajainen
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.simantics.utils.strings;

import java.io.File;

/**
 * @author Toni Kalajainen
 * 
 */
public class FileNameUtils {

    /**
     * Creates directories
     * @param path
     */
    public static void forcePath(String path) {
        // Create directories
        (new File(path)).mkdirs();
    }

    public static void deleteFile(String filename) {
        (new File(filename)).delete();
    }

    /**
     * Extracts file's directory Excludes last / \
     * 
     * @param filename
     *            the file
     * @return the path
     */
    public static String extractFileDir(String filename) {
        // construct directory name
        String splitted[] = filename.replaceAll("\\\\", "/").split("/");
        if (splitted.length > 1)
            return filename.substring(0, filename.length()
                    - splitted[splitted.length - 1].length() - 1);
        return "";
    }

    /**
     * Extracts file's name
     * 
     * @param path
     *            the path
     * @return the filename
     */
    public static String extractFileName(String path) {
        // construct directory name
        String splitted[] = path.replaceAll("\\\\", "/").split("/");
        if (splitted.length > 1)
            return splitted[splitted.length-1];
        return path;
    }

    /**
     * Extracts file's name before dot
     * 
     * @param filename
     *            the file name
     * @return the name
     */
    public static String extractFilePreDot(String filename) {
        // construct directory name
        String splitted[] = filename.split("\\.");
        if (splitted.length > 1)
            return filename.substring(0, filename.length()
                    - splitted[splitted.length - 1].length() - 1);
        return filename;
    }


    /**
     * Extracts file's extension
     * 
     * @param filename
     *            the file name
     * @return the name
     */
    public static String extractFileExt(String filename) {
        // construct directory name
        String splitted[] = filename.split("\\.");
        if (splitted.length > 1)
            return splitted[splitted.length-1];
        return "";
    }

    /**
     * Extracts file's directory Ixcludes last / \
     * 
     * @param filename
     *            the file
     * @return the path
     */
    public static String extractFilePath(String filename) {
        // construct directory name
        String splitted[] = filename.replaceAll("\\\\", "/").split("/");
        if (splitted.length > 1)
            return filename.substring(0, filename.length()
                    - splitted[splitted.length - 1].length());
        return "";
    }

    public static void main(String[] args) {
        System.out.println(extractFileDir("c:\\jees/pox/file.dat"));
        System.out.println(extractFilePath("c:\\jees/pox/file.dat"));
        System.out.println(extractFileName("c:\\jees/pox/file.dat"));
        System.out.println(extractFilePreDot("c:\\jees/pox/file.dat"));
        System.out.println(extractFileExt("c:\\jees/pox/file.dat"));
    }

}
