/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.format;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class SwitchFormat extends NumberFormat {

	private static final long serialVersionUID = -205210065554444251L;

	double low;
	double high;
	NumberFormat lowFormat;
	NumberFormat middleFormat;
	NumberFormat highFormat;
	
	public SwitchFormat(double low, double high, NumberFormat lowFormat, NumberFormat middleFormat, NumberFormat highFormat)
	{
		this.low = low;
		this.high = high;
		this.lowFormat = lowFormat;
		this.middleFormat = middleFormat;
		this.highFormat = highFormat;
	}
	
	@Override
	public StringBuffer format(double number, StringBuffer toAppendTo,
			FieldPosition pos) {
		
		NumberFormat f;
		double x = Math.abs(number);
		if (x==0.0) f = middleFormat; else
		if (x<=low) f = lowFormat; else
		if (x>=high) f = highFormat; else f = middleFormat;
		
		return f.format(number, toAppendTo, pos);
	}

	@Override
	public StringBuffer format(long number, StringBuffer toAppendTo,
			FieldPosition pos) {
		NumberFormat f;
		double x = Math.abs(number);
		if (x==0.0) f = middleFormat; else
		if (x<=low) f = lowFormat; else
		if (x>=high) f = highFormat; else f = middleFormat;
		
		return f.format(number, toAppendTo, pos);
	}

	@Override
	public Number parse(String source, ParsePosition parsePosition) {
		return 0;
	}

}
