/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.utils.datastructures.cache;

import java.util.Hashtable;
import java.util.Map;

/**
 * Registry is a value store where values are pre-registered and not 
 * requested on-demand as with strong and weak caches.
 * 
 * All values must be explicitly provided and removed.
 * 
 *
 */
public class Registry<K, V> extends Hashtable<K, V> implements IMapProvider<K, V>, Map<K, V> {

	private static final long serialVersionUID = 8509496982057736486L;

	public Registry() {
		super();
	}

	public Registry(int initialCapacity, float loadFactor) {
		super(initialCapacity, loadFactor);
	}

	public Registry(int initialCapacity) {
		super(initialCapacity);
	}

	public Registry(Map<? extends K, ? extends V> t) {
		super(t);
	}
	
}
