/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SetUnion2<T> extends ImmutableCollection<T> {

    List<Set<T>> sets;

    @Override
    public boolean contains(Object o) {
        for(Set<T> set : sets)
            if(set.contains(o))
                return true;
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for(Object o : c)
            if(!contains(o))
                return false;
        return true;
    }

    @Override
    public boolean isEmpty() {
        for(Set<T> set : sets)
            if(!set.isEmpty())
                return false;
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator<T>() {

            int setId = 0;
            Iterator<T> it = sets.get(0).iterator();
            T element = null;
            
            @Override
            public boolean hasNext() {
                while(true) {
                    if(element != null)
                        return true;
                    if(it.hasNext()) {
                        element = it.next();
                        for(int i=0;i<setId;++i)
                            if(sets.get(i).contains(element)) {
                                element = null;
                                break;
                            }
                    }
                    else {
                        ++setId;
                        if(setId < sets.size())
                            it = sets.get(setId).iterator();
                        else
                            return false;
                    }
                }
            }

            @Override
            public T next() {
                while(true) {
                    if(element != null)
                        return element;
                    if(it.hasNext()) {
                        element = it.next();
                        for(int i=0;i<setId;++i)
                            if(sets.get(i).contains(element)) {
                                element = null;
                                break;
                            }
                    }
                    else {
                        ++setId;
                        if(setId < sets.size())
                            it = sets.get(setId).iterator();
                        else
                            throw new InvalidParameterException();
                    }
                }
            }
            
        };
    }

    @Override
    public int size() {
        int count = sets.get(0).size();
        for(int i=1;i<sets.size();++i) {
            floop:
            for(T o : sets.get(i)) {
                for(int j=0;j<i;++j)
                    if(sets.get(j).contains(o))
                        break floop;
                ++count;
            }
        }
        return count;
    }       
    
}
