/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

/**
 * @author Tuukka Lehtonen
 */
public class Functions {

    /**
     * Returns a constant function that always evaluates to the specified
     * arguments.
     * 
     * @param <T>
     * @param t the desired result of the created function
     * @return
     */
    public static final <T> Function<T[]> constant(@SuppressWarnings("unchecked") final T... t) {
        return new Function<T[]>() {
            @Override
            public T[] execute(Object... obj) {
                return t;
            }
        };
    }

}
