/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

/**
 * @author Tuukka Lehtonen
 */
public final class Callables {

    public static class Static<T> implements Callable<T> {

        private final T t;

        public static <T> Static<T> make(T t) {
            return new Static<T>(t);
        }

        private Static(T t) {
            this.t = t;
        }

        @Override
        public T call() {
            return t;
        }

    }

    public static final Callable<Boolean> TRUE  = Static.make(Boolean.TRUE);

    public static final Callable<Boolean> FALSE = Static.make(Boolean.FALSE);

}
