/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.toolbar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.simantics.ui.toolbar.CommandStateListener;
import org.simantics.utils.datastructures.MapList;

public class CommandStateRegistry {
    private static CommandStateRegistry instance;
    private Map<IWorkbenchPart, Map<String, Boolean>> toggleStates = new HashMap<IWorkbenchPart, Map<String, Boolean>>();
    private Map<String, Boolean> defaultToggleStates = new HashMap<String, Boolean>();
    private Map<String, String> defaultRadioStates = new HashMap<String, String>();
    private Map<IWorkbenchPart, Map<String, String>> radioStates = new HashMap<IWorkbenchPart, Map<String, String>>();
    private ICommandService service;
    private IHandlerService handlerService;
    private List<CommandStateListener> listeners = new ArrayList<CommandStateListener>();
    private MapList<String, CommandStateListener> listenerWithCommandId = new MapList();
    private MapList<IWorkbenchPart, CommandStateListener> listenerWithPart = new MapList();
    private List<CommandStateListener> fireList = new ArrayList<CommandStateListener>();

    public static CommandStateRegistry getInstance() {
        if (instance == null) {
            instance = new CommandStateRegistry();
        }
        return instance;
    }

    private CommandStateRegistry() {
        this.service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
    }

    public void storeDefaultState(String commandId) {
        Command command = this.service.getCommand(commandId);
        State toggleState = command.getState("org.eclipse.ui.commands.toggleState");
        State radioState = command.getState("org.eclipse.ui.commands.radioState");
        if (toggleState != null) {
            if (!this.defaultToggleStates.containsKey(commandId)) {
                this.defaultToggleStates.put(commandId, this.getToggleState(command));
            }
        } else if (radioState != null) {
            String value = (String)radioState.getValue();
            if (!this.defaultRadioStates.containsKey(commandId)) {
                this.defaultRadioStates.put(commandId, value);
            }
        } else {
            throw new IllegalArgumentException("Command " + commandId + " does not have a state");
        }
    }

    public void setEditorState(IWorkbenchPart part, String commandId, boolean checked) {
        Map<String, Boolean> editorStates = this.toggleStates.get(part);
        if (editorStates == null) {
            editorStates = new HashMap<String, Boolean>();
            this.toggleStates.put(part, editorStates);
        }
        editorStates.put(commandId, checked);
        this.fireStateChange(part, commandId, Boolean.toString(checked));
    }

    public void setEditorState(IWorkbenchPart part, String commandId, String value) {
        Map<String, String> editorStates = this.radioStates.get(part);
        if (editorStates == null) {
            editorStates = new HashMap<String, String>();
            this.radioStates.put(part, editorStates);
        }
        editorStates.put(commandId, value);
        this.fireStateChange(part, commandId, value);
    }

    public Map<String, Boolean> getDefaultToggleStates() {
        return this.defaultToggleStates;
    }

    public Map<String, String> getDefaultRadioStates() {
        return this.defaultRadioStates;
    }

    public Map<String, Boolean> getEditorToggleStates(IWorkbenchPart part) {
        return this.toggleStates.get(part);
    }

    public Map<String, String> getEditorRadioStates(IWorkbenchPart part) {
        return this.radioStates.get(part);
    }

    public Boolean getToggleState(IWorkbenchPart part, String commandId) {
        if (part == null) {
            return this.defaultToggleStates.get(commandId);
        }
        Map<String, Boolean> editorStates = this.toggleStates.get(part);
        if (editorStates == null) {
            return this.defaultToggleStates.get(commandId);
        }
        return editorStates.get(commandId);
    }

    public String getRadioState(IWorkbenchPart part, String commandId) {
        if (part == null) {
            return this.defaultRadioStates.get(commandId);
        }
        Map<String, String> editorStates = this.radioStates.get(part);
        if (editorStates == null) {
            return this.defaultRadioStates.get(commandId);
        }
        return editorStates.get(commandId);
    }

    public void clearStates(IWorkbenchPart part) {
        this.toggleStates.remove(part);
        this.radioStates.remove(part);
        this.listenerWithPart.remove((Object)part);
    }

    private boolean getToggleState(Command command) {
        State toggleState = command.getState("org.eclipse.ui.commands.toggleState");
        return (Boolean)toggleState.getValue();
    }

    public void addListener(CommandStateListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void addListener(IWorkbenchPart part, CommandStateListener listener) {
        if (!this.listenerWithPart.contains((Object)part, (Object)listener)) {
            this.listenerWithPart.add((Object)part, (Object)listener);
        }
    }

    public void addListener(String commandId, CommandStateListener listener) {
        if (!this.listenerWithCommandId.contains((Object)commandId, (Object)listener)) {
            this.listenerWithCommandId.add((Object)commandId, (Object)listener);
        }
    }

    public void removeListener(CommandStateListener listener) {
        this.listeners.remove(listener);
        HashSet commandIds = new HashSet();
        commandIds.addAll(this.listenerWithCommandId.getKeys());
        for (String commandId : commandIds) {
            this.listenerWithCommandId.remove((Object)commandId, (Object)listener);
        }
        commandIds.clear();
        HashSet parts = new HashSet();
        parts.addAll(this.listenerWithPart.getKeys());
        for (IWorkbenchPart part : parts) {
            this.listenerWithPart.remove((Object)part, (Object)listener);
        }
        parts.clear();
    }

    private void fireStateChange(IWorkbenchPart part, String commandId, String state) {
        this.fireList.clear();
        this.fireList.addAll(this.listeners);
        List list = this.listenerWithCommandId.getValues((Object)commandId);
        if (list != null) {
            this.fireList.addAll(list);
        }
        if ((list = this.listenerWithPart.getValues((Object)part)) != null) {
            this.fireList.addAll(list);
        }
        for (CommandStateListener l : this.fireList) {
            l.stateChanged(part, commandId, state);
        }
    }
}

