/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.selection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.ReadInterface;
import org.simantics.ui.selection.AnyResource;
import org.simantics.ui.selection.AnyVariable;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;

public class VariableWorkbenchSelectionElement
implements WorkbenchSelectionElement {
    private final Variable variable;

    public VariableWorkbenchSelectionElement(Variable variable) {
        this.variable = variable;
    }

    @Override
    public <T> T getContent(WorkbenchSelectionContentType<T> contentType) {
        if (contentType instanceof AnyResource) {
            AnyResource type = (AnyResource)contentType;
            try {
                return (T)type.processor.sync((ReadInterface)new UnaryRead<Variable, Resource>(this.variable){

                    public Resource perform(ReadGraph graph) throws DatabaseException {
                        return ((Variable)this.parameter).getRepresents(graph);
                    }
                });
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
        } else if (contentType instanceof AnyVariable) {
            return (T)this.variable;
        }
        return null;
    }

    public int hashCode() {
        return this.variable.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof VariableWorkbenchSelectionElement)) {
            return false;
        }
        VariableWorkbenchSelectionElement vwse = (VariableWorkbenchSelectionElement)object;
        return this.variable.equals(vwse.variable);
    }
}

