/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.auth;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.simantics.ui.auth.LoginComposite;
import org.simantics.ui.auth.model.LoginModel;

public class LoginDialog
extends TrayDialog {
    private static final String LOGIN_DIALOG = "LoginDialog";
    private IDialogSettings dialogBoundsSettings;
    private LoginComposite c;
    private final LoginModel model;

    protected LoginDialog(Shell parentShell, IDialogSettings settings, LoginModel model) {
        super(parentShell);
        this.model = model;
        this.dialogBoundsSettings = settings.getSection(LOGIN_DIALOG);
        if (this.dialogBoundsSettings == null) {
            this.dialogBoundsSettings = settings.addNewSection(LOGIN_DIALOG);
        }
    }

    protected int getShellStyle() {
        return super.getShellStyle();
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Login - " + this.model.getServer().getName());
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.c = new LoginComposite(composite, 0, this.model);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.c);
        LoginDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogBoundsSettings;
    }

    protected Point getInitialSize() {
        Point result;
        Point defaultSize = this.getShell().computeSize(-1, -1, true);
        if (defaultSize.equals((Object)(result = super.getInitialSize()))) {
            return new Point(400, 220);
        }
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }
}

