/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.DoubleClickEvent;
import org.simantics.ui.IDoubleClickAction;
import org.simantics.ui.IDoubleClickExtension;
import org.simantics.utils.ui.ExceptionUtils;

public class DoubleClickExtension
implements IDoubleClickExtension {
    private static final IDoubleClickAction NO_ACTION = new IDoubleClickAction(){

        @Override
        public void doubleClickEvent(DoubleClickEvent e) throws DatabaseException {
        }
    };
    private final IConfigurationElement config;
    private final String name;
    private final double priority;
    private IDoubleClickAction cachedAction;

    DoubleClickExtension(IConfigurationElement config, String name, double priority) {
        this.config = config;
        this.name = name;
        this.priority = priority;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    @Override
    public synchronized IDoubleClickAction getAction() {
        if (this.cachedAction == null) {
            try {
                this.cachedAction = (IDoubleClickAction)this.config.createExecutableExtension("class");
            }
            catch (CoreException e) {
                ExceptionUtils.logError((String)("Failed to instantiate " + this.config.getName() + " extension with name \"" + this.config.getAttribute("name") + "\": " + e.getMessage()), (Throwable)e);
                this.cachedAction = NO_ACTION;
            }
        }
        return this.cachedAction;
    }

    public String toString() {
        return "DoubleClickExtension [name=" + this.name + ", class=" + this.config.getAttribute("class") + ", priority=" + this.priority + "]";
    }
}

