/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.editor;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.DoubleClickEvent;
import org.simantics.ui.IDoubleClickAction;
import org.simantics.ui.workbench.action.IWorkbenchActionHints;
import org.simantics.ui.workbench.action.ResourceEditorAdapterAction;

/**
 * @author Tuukka Lehtonen
 */
public class OpenDefaultEditor implements IDoubleClickAction {

    @Override
    public void doubleClickEvent(DoubleClickEvent e) {
        ReadGraph g = e.getGraph();
        Object r = e.getResource();

        Boolean remember = e.getHintContext().getHint(IWorkbenchActionHints.KEY_REMEMBER);
        final boolean rememberChoice = remember != null ? remember : false;

        Boolean ask = e.getHintContext().getHint(IWorkbenchActionHints.KEY_ALWAYS_ASK);
        boolean alwaysAsk = ask != null ? ask : false;

        EditorAdapter primaryAdapter = EditorRegistry.getInstance().getMappings().get(r);
        if (!alwaysAsk && primaryAdapter != null) {
            e.add(new ResourceEditorAdapterAction(primaryAdapter, r));
        } else {
            try {
                EditorAdapter[] editorAdapters = EditorRegistry.getInstance().getAdaptersFor(g, r);
                for (final EditorAdapter a : editorAdapters) {
                    e.add(new ResourceEditorAdapterAction(a, r) {
                        @Override
                        protected void safeRun() throws Exception {
                            super.safeRun();

                            if (rememberChoice && a.getPriority() >= 0) {
                                // Make this choice the default for the next time.
                                EditorRegistry.getInstance().getMappings().put(getResource(), getAdapter());
                            }
                        }
                    });
                }
            } catch (DatabaseException ex) {
            }
        }
    }

}
