package org.simantics.ui.workbench.editor;

import java.util.Collection;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphEditorAdapterDescriptor implements EditorAdapterDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphEditorAdapterDescriptor.class);

	private final String editorId;
	private final String label;
	private final ImageDescriptor imageDescriptor;
	private final Resource contribution;
	private final int priority;

	public GraphEditorAdapterDescriptor(String editorId, String label, ImageDescriptor imageDescriptor, Resource contribution, int priority) {
		this.editorId = editorId;
		this.label = label;
		this.imageDescriptor = imageDescriptor;
		this.contribution = contribution;
		this.priority = priority;
	}
	
	@Override
	public String getId() {
		return editorId;
	}

	@Override
	public String getGroupId() {
		return null;
	}

	@Override
	public EditorAdapter getAdapter() {
		
		return new AbstractResourceEditorAdapter(editorId, null, priority) {

			@Override
			public String getName() {
				return label;
			}

			@Override
			public ImageDescriptor getIcon() {
				return imageDescriptor;
			}

			@Override
			public int getPriority() {
				return priority;
			}
			
			@Override
			public String getEditorId() {
				return editorId;
			}

			@Override
			public boolean canHandle(ReadGraph graph, Resource input) throws DatabaseException {
				
				ModelingResources MOD = ModelingResources.getInstance(graph);
		        Boolean result = Simantics.tryInvokeSCL(graph, contribution, MOD.EditorContribution_canHandle, input);
		        if(result == null) return false;
		        return result;
		        
			}

			@Override
			public void openEditor(Object input) throws Exception {
				
		        Resource r = ResourceAdaptionUtils.toSingleResource(input);
				
		        Simantics.getSession().asyncRequest(new ReadRequest() {
		            @Override
		            public void run(ReadGraph g) throws DatabaseException {

		                Variable variable = Variables.getVariable(g, r);
		                final Resource model = g.syncRequest(new PossibleIndexRoot(r));
		                final RVI rvi = variable.getPossibleRVI(g);
		                
		                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {
		                    @Override
		                    public void run() {
		                        try {
		                            WorkbenchUtils.openEditor(editorId, new ResourceEditorInput2(editorId, r, model, rvi));
		                        } catch (PartInitException e) {
		                            LOGGER.error("Failed to open the graph editor", e);
		                        }
		                    }
		                });
		            }
		        });
			}
			
		};
	}

	@Override
	public Collection<String> getInContexts() {
		return null;
	}

	@Override
	public boolean isActive(Collection<?> activeContextIds) {
		return true;
	}

}
