package org.simantics.ui.workbench.e4;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.ui.workbench.IResourceEditorInput2;

/**
 * @author Tuukka Lehtonen
 * @since 1.22
 */
public class E4ResourceEditorInput2 extends E4ResourceEditorInput implements IResourceEditorInput2 {

    protected final Resource model;
    protected final String rvi;
    protected transient Variable variable;

    public E4ResourceEditorInput2(Resource resource, Resource model, String rvi) {
        super(resource);
        this.model = model;
        this.rvi = rvi;
    }

    @Override
    public void dispose() {
        // Nullify to prevent the class from keeping unnecessary references to
        // possible Variable implementation backend resources.
        variable = null;
    }

    @Override
    public Resource getModel(ReadGraph graph) {
        return model;
    }

    @Override
    public String getRVI() {
        return rvi;
    }

    @Override
    public boolean exists(ReadGraph graph) throws DatabaseException {
        if (!super.exists(graph))
            return false;

        if (model != null) {
            boolean modelExists = graph.hasStatement(model);
            if (!modelExists)
                return false;
        }

        if(rvi != null) {
            Variable context = Variables.getPossibleConfigurationContext(graph, model);
            if (context == null)
                return false;
            RVI rvi_ = RVI.fromResourceFormat(graph, rvi);
            Variable variable = rvi_.resolvePossible(graph, context);
            if (variable == null)
                return false;
        }

        return true;
    }

    @Override
    public Variable getVariable() throws DatabaseException {
        if (variable != null)
            return variable;
        return Simantics.getSession().syncRequest(new UniqueRead<Variable>() {
            @Override
            public Variable perform(ReadGraph graph) throws DatabaseException {
                return getVariable(graph);
            }
        });
    }

    protected Variable getVariable0(ReadGraph graph) throws DatabaseException {
        Resource model = getModel(graph);
        String rvi = getRVI();
        // Model + RVI
        if (rvi != null) {
            Variable configuration = Variables.getConfigurationContext(graph, model);
            RVI rrvi = RVI.fromResourceFormat(graph, rvi);
            return rrvi.resolve(graph, configuration);
        }
        // Absolute URI
        else {
            return Variables.getVariable(graph, model);
        }
    }

    @Override
    public Variable getVariable(ReadGraph graph) throws DatabaseException {
        Variable v = getVariable0(graph);
        this.variable = v;
        return v;
    }

}
