/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.dnd;

import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.widgets.Control;

/**
 * An SWT {@link DragSourceEffect} implementation that prevents SWT DnD
 * operations from showing screenshots of the dragged data. Useful when SWT is
 * used with AWT which tends to cause unwanted visual effects during drags.
 * 
 * @author Tuukka Lehtonen
 */
public class NoImageDragSourceEffect extends DragSourceEffect {

    public NoImageDragSourceEffect(Control control) {
        super(control);
    }

    @Override
    public void dragStart(DragSourceEvent event) {
        event.image = null;
    }

}
