/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.dnd;

import java.awt.datatransfer.SystemFlavorMap;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class LocalObjectTransfer extends ByteArrayTransfer {

    // First attempt to create a UUID for the type name to make sure that
    // different Eclipse applications use different "types" of
    // <code>LocalSelectionTransfer</code>
	public static final String TYPE_NAME = SystemFlavorMap.encodeJavaMIMEType(LocalObjectTransferable.TYPE_NAME);
	
//	private static int getMapping() {
//
//		for(Map.Entry<DataFlavor, String> entry : SystemFlavorMap.getDefaultFlavorMap().getNativesForFlavors(new DataFlavor[] { LocalObjectTransferable.FLAVOR }).entrySet()) {
//			for(long l : DataTransferer.getInstance().getFormatsForFlavorAsArray(entry.getKey(), (FlavorTable)SystemFlavorMap.getDefaultFlavorMap())) {
//				return (int)l;
//			}
//		}
//		DataFlavor[] flavors = SystemFlavorMap.getDefaultFlavorMap().getNativesForFlavors(new DataFlavor[] { LocalObjectTransferable.FLAVOR }).keySet().toArray(new DataFlavor[0]);
//		for(long l : DataTransferer.getInstance().getFormatsForFlavors(flavors, (FlavorTable)SystemFlavorMap.getDefaultFlavorMap()).keySet()) {
//			return (int)l;
//		}
//		
//		throw new Error("No mapping.");
//		
//	}
	// In Linux (Ubuntu 14.04) using SystemFlavorMap to get the type id gives different result than what is received with drop data (TransferData.type) 
    private static final int TYPEID = registerType(TYPE_NAME);//getMapping();
    
	private static final LocalObjectTransfer INSTANCE = new LocalObjectTransfer();

    Object transferredObject;

    /**
     * Only the singleton instance of this class may be used. 
     */
    protected LocalObjectTransfer() {
        // do nothing
    }

    /**
     * Returns the singleton.
     * 
     * @return the singleton
     */
    public static LocalObjectTransfer getTransfer() {
        return INSTANCE;
    }

    /**
     * Tests whether native drop data matches this transfer type.
     * 
     * @param result result of converting the native drop data to Java
     * @return true if the native drop data does not match this transfer type.
     * 	false otherwise.
     */
    private boolean isInvalidNativeType(Object result) {
        return !(result instanceof byte[])
                || !TYPE_NAME.equals(new String((byte[]) result));
    }

    /**
     * Returns the type id used to identify this transfer.
     * 
     * @return the type id used to identify this transfer.
     */
    protected int[] getTypeIds() {
    	return new int[] { TYPEID };
    }

    /**
     * Returns the type name used to identify this transfer.
     * 
     * @return the type name used to identify this transfer.
     */
    protected String[] getTypeNames() {
        return new String[] { TYPE_NAME };
    }

    /**
     * Overrides org.eclipse.swt.dnd.ByteArrayTransfer#javaToNative(Object,
     * TransferData).
     * Only encode the transfer type name since the selection is read and
     * written in the same process.
     * 
     * @see org.eclipse.swt.dnd.ByteArrayTransfer#javaToNative(java.lang.Object, org.eclipse.swt.dnd.TransferData)
     */
    public void javaToNative(Object object, TransferData transferData) {
    	//System.out.println("javaToNative " + object);
        transferredObject = object;
        byte[] check = TYPE_NAME.getBytes();
        super.javaToNative(check, transferData);
    }

    /**
     * Overrides org.eclipse.swt.dnd.ByteArrayTransfer#nativeToJava(TransferData).
     * Test if the native drop data matches this transfer type.
     * 
     * @see org.eclipse.swt.dnd.ByteArrayTransfer#nativeToJava(TransferData)
     */
    public Object nativeToJava(TransferData transferData) {
    	//System.out.println("nativeToJava " + transferredObject);
        Object result = super.nativeToJava(transferData);
        if (isInvalidNativeType(result)) {
            Policy.getLog().log(new Status(
                            IStatus.ERROR,
                            Policy.JFACE,
                            IStatus.ERROR,
                            JFaceResources.getString("LocalObjectTransfer.errorMessage"), null)); //$NON-NLS-1$
        }
        return transferredObject;
    }
    
    public void clear() {
    	//System.out.println("LocalObjectTransfer clear");
        transferredObject = null;
    }
    
    public Object getObject() {
    	//System.out.println("LocalObjectTransfer get " + transferredObject);
        return transferredObject;
    }
    
    public void setObject(Object object) {
    	//System.out.println("LocalObjectTransfer set " + object);
    	transferredObject = object;
    }
    
}
