/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend.impl;

import java.awt.Color;
import org.simantics.trend.configuration.ViewProfile;
import org.simantics.trend.impl.Plot;

class ViewRenderingProfile {
    public Color backgroundColor1 = Plot.PLOT_AREA_BG_GRADIENT_COLOR_BOTTOM;
    public Color backgroundColor2 = Plot.PLOT_AREA_BG_GRADIENT_COLOR_TOP;
    public Color gridColor = Plot.GRID_LINE_COLOR;

    ViewRenderingProfile() {
    }

    public ViewRenderingProfile read(ViewProfile p) {
        if (p.backgroundColor != null) {
            float[] bg = p.backgroundColor;
            int len = bg.length;
            if (len >= 6) {
                this.backgroundColor1 = ViewRenderingProfile.toColor(bg, 0);
                this.backgroundColor2 = ViewRenderingProfile.toColor(bg, 3);
            } else if (len >= 3) {
                this.backgroundColor1 = ViewRenderingProfile.toColor(bg, 0);
                this.backgroundColor2 = null;
            }
        } else {
            this.backgroundColor1 = Plot.PLOT_AREA_BG_GRADIENT_COLOR_BOTTOM;
            this.backgroundColor2 = Plot.PLOT_AREA_BG_GRADIENT_COLOR_TOP;
        }
        this.gridColor = p.gridColor != null && p.gridColor.length >= 3 ? ViewRenderingProfile.toColor(p.gridColor, 0) : Plot.GRID_LINE_COLOR;
        return this;
    }

    private static Color toColor(float[] array, int offset) {
        return new Color(ViewRenderingProfile.clamp(array[offset]), ViewRenderingProfile.clamp(array[offset + 1]), ViewRenderingProfile.clamp(array[offset + 2]));
    }

    private static float clamp(float v) {
        return Math.max(0.0f, Math.min(v, 1.0f));
    }
}

