/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.utils.GridUtil;
import org.simantics.scenegraph.ExportableWidget;
import org.simantics.scenegraph.INode;
import org.simantics.trend.impl.TrendGraphicalNode;

@ExportableWidget.OutputWidget(value={"text"})
public class TextNode
extends TrendGraphicalNode {
    private static final long serialVersionUID = 8508750881358776559L;
    String text = null;
    Font font = null;
    Color color = Color.BLACK;
    transient double sx;
    transient double sy;
    transient double tw;
    transient double th;
    transient double tx;
    transient double ty;

    @INode.SyncField(value={"font"})
    public void setFont(Font font) {
        this.font = font;
    }

    @INode.SyncField(value={"text"})
    public void setText(String text) {
        this.text = text;
    }

    @INode.SyncField(value={"color"})
    public void setColor(Color color) {
        this.color = color;
    }

    public void layout() {
        GlyphVector glyphVector = this.font.createGlyphVector(GridUtil.frc, this.text);
        Rectangle2D tr = glyphVector.getVisualBounds().getBounds2D();
        this.tw = tr.getWidth();
        this.th = tr.getHeight();
        this.sx = this.getWidth() / this.tw;
        this.sy = this.getHeight() / this.th;
        this.tx = -tr.getX();
        this.ty = -tr.getY();
        if (this.sx < 1.0) {
            this.tw *= this.sx;
            this.th *= this.sx;
            this.sy *= this.sx;
            this.tx *= this.sx;
            this.ty *= this.sx;
        } else {
            this.sx = 1.0;
        }
        if (this.sy < 1.0) {
            this.tw *= this.sy;
            this.th *= this.sy;
            this.sx *= this.sy;
            this.tx *= this.sy;
            this.ty *= this.sy;
        } else {
            this.sy = 1.0;
        }
        this.tx += (this.bounds.getWidth() - this.tw) / 2.0;
        this.ty += (this.bounds.getHeight() - this.th) / 2.0;
    }

    @Override
    protected void doRender(Graphics2D g) {
        if (this.text == null || this.bounds == null || this.font == null || this.color == null) {
            return;
        }
        g.setFont(this.font);
        g.setColor(this.color);
        AffineTransform at = g.getTransform();
        g.translate(this.bounds.getX(), this.bounds.getY());
        g.translate(this.tx, this.ty);
        g.scale(this.sx, this.sy);
        g.drawString(this.text, 0, 0);
        g.setTransform(at);
    }
}

