/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.trend.impl;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

import org.simantics.scenegraph.g2d.G2DNode;

public abstract class TrendGraphicalNode extends G2DNode implements TrendLayout {

	private static final long serialVersionUID = 1L;
	
	Rectangle2D bounds = new Rectangle2D.Double();

	public double getWidth() { 
		return bounds.getWidth();
	}
	
	public double getHeight() {
		return bounds.getHeight();
	}
	
	public void setSize(double w, double h) {
		if (bounds.getWidth()==w && bounds.getHeight()==h) return;
		bounds.setFrame(0, 0, w, h);
	}
	
	public double getX() {
		return transform.getTranslateX();
	}
	
	public double getY() {
		return transform.getTranslateY();
	}
	
	public void setTranslate(double x, double y) {
		setTransform(AffineTransform.getTranslateInstance(x, y));
	}
	
	@Override
	public Rectangle2D getBoundsInLocal() {
		return bounds;
	}

	@Override
	public void render(Graphics2D g2d) {
		AffineTransform at = g2d.getTransform();
		g2d.transform( transform );
		try {
			doRender(g2d);
		} finally {
			g2d.setTransform(at);
		}
	}
	
	public TrendNode getTrend() {
		return (TrendNode) getParent();
	}
	
	protected abstract void doRender(Graphics2D g2d);

	
}
