package org.simantics.tests.modelled.ui.adapters;

import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.browsing.ui.model.visuals.VisualsRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.tests.modelled.ontology.TestsResource;

public enum IsTestIgnored implements Test, VisualsRule, ImageRule {

    INSTANCE;

    public static IsTestIgnored get() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return Resource.class.equals(contentType);
    }

    @Override
    public boolean test(ReadGraph graph, Object content) throws DatabaseException {
        if (content instanceof Resource) {
            Resource resource = (Resource) content;
            TestsResource TESTS = TestsResource.getInstance(graph);
            return graph.getPossibleRelatedValue2(resource, TESTS.ignore, Bindings.BOOLEAN);
        }
        return false;
    }

    @Override
    public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content) throws DatabaseException {
        // TODO Auto-generated method stub
        return null;
    }

}
