package org.simantics.tests.modelled.ui;

import java.text.DecimalFormat;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.simantics.scl.compiler.module.coverage.Coverage;

public final class RedGreenBar {

    private static final int BORDER_LEFT = 2;
    private static final int BORDER_RIGHT = 10;
    private static final int BORDER_TOP = 3;
    private static final int BORDER_BOTTOM = 4;

    private static final String MAX_PERCENTAGE_STRING = new DecimalFormat("0.0 %").format(1.0);
    
    private static final ImageDescriptor redbar = Activator.getImageDescriptor("icons/redbar.gif"); //$NON-NLS-1$
    private static final ImageDescriptor greenbar = Activator.getImageDescriptor("icons/greenbar.gif"); //$NON-NLS-1$
    private static Image redbarIcon = Activator.createManagedImage(redbar);
    private static Image greenbarIcon = Activator.createManagedImage(greenbar);
    
    private RedGreenBar() {
    }

//    public static void draw(Event event, int columnWith, ICounter counter) {
//        draw(event, columnWith, counter, counter.getTotalCount());
//    }

    public static void draw(Event event, int columnWith, Coverage coverage) {
        int maxTotal = coverage.getTotalCodeSize();
        if (maxTotal == 0)
            return;
        final int maxWidth = getMaxWidth(event, columnWith);
        final int redLength = maxWidth * coverage.getMissedCodeSize() / maxTotal;
        bar(event, redbarIcon, 0, redLength);
        final int greenLength = maxWidth * coverage.getCoveredCodeSize() / maxTotal;
        bar(event, greenbarIcon, redLength, greenLength);
    }

    private static void bar(Event event, Image image, int xOffset, int width) {
        final int height = event.getBounds().height - BORDER_TOP - BORDER_BOTTOM;
        event.gc.drawImage(image, 0, 0, 1, 10, event.x + xOffset + BORDER_LEFT,
                event.y + BORDER_TOP, width, height);
    }

    private static int getMaxWidth(Event event, int columnWith) {
        final int textWidth = event.gc.textExtent(MAX_PERCENTAGE_STRING).x;
        final int max = columnWith - BORDER_LEFT - BORDER_RIGHT - textWidth;
        return Math.max(0, max);
    }

}