package org.simantics.tests.modelled.junit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.tests.modelled.ontology.TestsResource;
import org.simantics.utils.strings.AlphanumComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RuntimeTestCollector {

    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeTestCollector.class);
    
    /**
     * TODO: The idea of this class was to collect all the tests from shared libraries and construct
     * JUnit tests out of them programmatically and then run them with JUnit to get results
     * 
     */
    private static Collection<RuntimeSTSSuiteRunner> collectTestsFromGraph() {
        try {
            Collection<RuntimeSTSSuiteRunner> suitess = Simantics.getSession().syncRequest(new UniqueRead<Collection<RuntimeSTSSuiteRunner>>() {

                @Override
                public Collection<RuntimeSTSSuiteRunner> perform(ReadGraph graph) throws DatabaseException {
                    
                    List<Resource> sharedOntologies = Simantics.applySCL("Simantics/SharedOntologies", "getSharedOntologies", graph, Tuple0.INSTANCE);
                    if (LOGGER.isInfoEnabled())
                        LOGGER.info("Found {} shared ontologies from graph",  sharedOntologies.size());
                    Set<RuntimeSTSSuiteRunner> suites = new HashSet<>();
                    TestsResource TESTS = TestsResource.getInstance(graph);
                    Layer0 L0 = Layer0.getInstance(graph);
                    for (Resource sharedOntology : sharedOntologies) {
                        if (LOGGER.isInfoEnabled())
                            LOGGER.info("Searching {} for modelled tests", graph.getURI(sharedOntology));
                        List<Resource> stsSuites = ModelingUtils.searchByType(graph, sharedOntology, TESTS.STSSuite);
                        for (Resource stsSuite : stsSuites) {
                            try {
                                String suiteName = graph.getURI(stsSuite);
    
                                Collection<Resource> tests = graph.syncRequest(new ObjectsWithType(stsSuite, L0.ConsistsOf, TESTS.STSTest));
                                if (tests.isEmpty())
                                    continue;
    
                                RuntimeSTSSuiteRunner suite = new RuntimeSTSSuiteRunner(RuntimeSTSSuiteRunner.class, suiteName);
                                List<RuntimeSTSTestRunner> testRunners = new ArrayList<>();
                                for (Resource test : tests) {
                                    String testName = graph.getRelatedValue(test, L0.HasName, Bindings.STRING);
                                    String code = graph.getRelatedValue(test, TESTS.STSTest_definition, Bindings.STRING);
                                    Integer priority = graph.getPossibleRelatedValue(test, TESTS.STSTest_executionPriority, Bindings.INTEGER);
                                    RuntimeSTSTestRunner testCase = new RuntimeSTSTestRunner(testName, code, priority);
                                    testRunners.add(testCase);
                                }
                                
                                testRunners.sort((test1, test2) -> {
                                    if (test1.getPriority() < test2.getPriority())
                                        return -1;
                                    else if (test1.getPriority() > test2.getPriority())
                                        return 1;
                                    else return AlphanumComparator.COMPARATOR.compare(test1.getName(), test2.getName());
                                });
                                suite.addChildren(testRunners);
                                suites.add(suite);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    return suites;
                }
            });
            return suitess;
        } catch (DatabaseException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static List<RuntimeSTSSuiteRunner> collectTests() {
        return new ArrayList<>(collectTestsFromGraph());
    }
}
