/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.simantics.Simantics;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.SelectionDataResolver;
import org.simantics.browsing.ui.swt.DefaultSelectionDataResolver;
import org.simantics.browsing.ui.swt.GraphExplorerFactory;
import org.simantics.browsing.ui.swt.ViewArgumentUtils;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.project.ProjectKeys;
import org.simantics.team.internal.Images;
import org.simantics.team.ui.ChangeSetElement;
import org.simantics.team.ui.CommentContentProvider;
import org.simantics.team.ui.DisplayElement;
import org.simantics.team.ui.RedoContextElement;
import org.simantics.team.ui.ResourceElement;
import org.simantics.team.ui.StringElement;
import org.simantics.team.ui.UndoCombinedElement;
import org.simantics.team.ui.UndoContextElement;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.disposable.DisposeState;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.HintTracker;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.datastructures.hints.IHintTracker;
import org.simantics.utils.ui.LayoutUtils;

public class StagingView
extends ViewPart {
    protected LocalResourceManager resourceManager;
    protected Composite parent;
    protected TreeViewer treeViewer;
    private Map<String, String> args;
    private ISessionContextProvider contextProvider;
    private ISessionContext sessionContext;
    protected IMemento memento;
    private IHintTracker sessionContextTracker = new SessionContextProjectTracker();
    private DisposeState disposeState = DisposeState.Alive;
    protected ISessionContextChangedListener contextChangeListener = new ISessionContextChangedListener(){

        public void sessionContextChanged(SessionContextChangedEvent event) {
            StagingView.this.sessionContext = event.getNewValue();
            StagingView.this.sessionContextTracker.track((IHintContext)StagingView.this.sessionContext);
        }
    };

    protected void setSessionContextTracker(IHintTracker tracker) {
        this.sessionContextTracker = tracker;
    }

    protected Map<String, String> getViewArguments() {
        return this.args;
    }

    protected DisposeState getDisposeState() {
        return this.disposeState;
    }

    public ISessionContext getSessionContext() {
        return this.sessionContext;
    }

    public ISessionContextProvider getSessionContextProvider() {
        return this.contextProvider;
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.treeViewer = new TreeViewer(parent, 65540);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()), (Control)this.treeViewer.getTree());
        Images.getInstance(JFaceResources.getResources());
        TreeColumnLayout ad = new TreeColumnLayout();
        parent.setLayout((Layout)ad);
        this.treeViewer.getTree().setHeaderVisible(true);
        TreeViewerColumn nameColumn = new TreeViewerColumn(this.treeViewer, 16384);
        nameColumn.getColumn().setText("Comment");
        nameColumn.getColumn().setWidth(200);
        nameColumn.setLabelProvider((CellLabelProvider)new MyColumnLabelProvider());
        ad.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(80, 100));
        this.createControls(parent);
        this.attachToSession();
    }

    public void dispose() {
        this.disposeState = DisposeState.Disposing;
        try {
            if (this.contextProvider != null) {
                this.contextProvider.removeContextChangedListener(this.contextChangeListener);
                this.contextProvider = null;
            }
            this.sessionContextTracker.untrack();
            this.resourceManager.dispose();
            this.resourceManager = null;
            this.args = null;
            this.sessionContext = null;
            this.parent = null;
            super.dispose();
        }
        finally {
            this.disposeState = DisposeState.Disposed;
        }
    }

    public void setFocus() {
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.args = ViewArgumentUtils.parseViewArguments((IViewPart)this);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.args = ViewArgumentUtils.parseViewArguments((IViewPart)this);
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        if (this.memento != null) {
            memento.putMemento(this.memento);
        }
    }

    protected final void attachToSession() {
        this.contextProvider = SimanticsUI.getSessionContextProvider((Object)this.getViewSite().getWorkbenchWindow());
        this.contextProvider.addContextChangedListener(this.contextChangeListener);
        this.applySessionContext(this.contextProvider.getSessionContext());
    }

    protected void createControls(Composite parent) {
        parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1, (boolean)false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.treeViewer.getTree());
        this.treeViewer.setContentProvider((IContentProvider)new CommentContentProvider(Simantics.getSession()));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof ChangeSetElement) {
                    return Images.getInstance().CHANGE_SET_IMAGE;
                }
                if (element instanceof DisplayElement) {
                    return Images.getInstance().DISPLAY_IMAGE;
                }
                if (element instanceof ResourceElement) {
                    return Images.getInstance().RESOURCE_IMAGE;
                }
                if (element instanceof StringElement) {
                    return Images.getInstance().STRING_IMAGE;
                }
                if (element instanceof UndoCombinedElement) {
                    return Images.getInstance().COMBINED_IMAGE;
                }
                if (element instanceof RedoContextElement) {
                    return Images.getInstance().REDO_IMAGE;
                }
                if (element instanceof UndoContextElement) {
                    return Images.getInstance().UNDO_IMAGE;
                }
                return Images.getInstance().OTHER_IMAGE;
            }

            public String getText(Object element) {
                return element.toString();
            }
        });
        this.treeViewer.setInput((Object)this);
        new ItemDetailToolTip(this.treeViewer, this.treeViewer.getTree(), null);
    }

    protected GraphExplorer createExplorerControl(Composite parent) {
        return GraphExplorerFactory.getInstance().selectionDataResolver((SelectionDataResolver)new DefaultSelectionDataResolver()).create(parent);
    }

    protected final boolean applySessionContext(ISessionContext context) {
        if (this.disposeState != DisposeState.Alive) {
            return false;
        }
        this.sessionContext = context;
        this.sessionContextTracker.track((IHintContext)this.sessionContext);
        return true;
    }

    private class ItemDetailToolTip
    extends NameAndDescriptionToolTip {
        private final boolean DEBUG = false;
        private TreeViewer viewer;
        private Tree tree;

        private ItemDetailToolTip(TreeViewer viewer, Tree tree, ViewerFilter filter) {
            super((Control)tree, 2);
            this.DEBUG = false;
            this.tree = tree;
            this.viewer = viewer;
            this.setHideOnMouseDown(false);
        }

        public Point getLocation(Point tipSize, Event event) {
            ViewerCell cell = this.viewer.getCell(new Point(event.x, event.y));
            if (cell != null) {
                return this.tree.toDisplay(event.x, cell.getBounds().y + cell.getBounds().height);
            }
            return super.getLocation(tipSize, event);
        }

        protected Object getToolTipArea(Event event) {
            return this.viewer.getCell(new Point(event.x, event.y));
        }

        @Override
        protected void addContent(Composite destination, Object modelElement) {
            DisplayElement item = (DisplayElement)modelElement;
            String text = null;
            if (item != null) {
                text = modelElement.toString();
                this.createEntryWithText(destination, null, text.toString());
            }
        }

        @Override
        protected Object getModelElement(Event event) {
            TreeItem treeItem = this.tree.getItem(new Point(event.x, event.y));
            if (treeItem == null) {
                return null;
            }
            return treeItem.getData();
        }
    }

    class MyColumnLabelProvider
    extends ColumnLabelProvider {
        MyColumnLabelProvider() {
        }

        public void update(ViewerCell cell) {
            cell.setText("Kraa");
            cell.setImage(Images.getInstance().OTHER_IMAGE);
        }
    }

    private abstract class NameAndDescriptionToolTip
    extends ToolTip {
        public NameAndDescriptionToolTip(Control control, int style) {
            super(control, style, false);
        }

        protected abstract Object getModelElement(Event var1);

        protected boolean shouldCreateToolTip(Event event) {
            if (!super.shouldCreateToolTip(event)) {
                return false;
            }
            Object tableElement = this.getModelElement(event);
            return tableElement != null && tableElement instanceof DisplayElement;
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            Object modelElement = this.getModelElement(event);
            Image iconImage = null;
            String nameString = "no name";
            if (modelElement instanceof DisplayElement) {
                iconImage = null;
                nameString = "name";
            }
            Composite composite = new Composite(parent, 0);
            composite.setBackground(parent.getDisplay().getSystemColor(29));
            composite.setLayout((Layout)new GridLayout(2, false));
            Label title = this.createEntry(composite, iconImage, nameString);
            GridDataFactory.createFrom((GridData)((GridData)title.getLayoutData())).hint(-1, -1).applyTo((Control)title);
            this.addContent(composite, modelElement);
            return composite;
        }

        protected Label createEntry(Composite parent, Image icon, String text) {
            if (icon != null) {
                Label iconLabel = new Label(parent, 0);
                iconLabel.setImage(icon);
                iconLabel.setBackground(parent.getDisplay().getSystemColor(29));
                iconLabel.setData((Object)new GridData());
            }
            Label textLabel = new Label(parent, 64);
            if (icon == null) {
                GridDataFactory.generate((Control)textLabel, (int)2, (int)1);
            } else {
                GridDataFactory.generate((Control)textLabel, (int)1, (int)1);
            }
            textLabel.setText(text);
            textLabel.setBackground(parent.getDisplay().getSystemColor(29));
            return textLabel;
        }

        protected Text createEntryWithText(Composite parent, Image icon, String text) {
            if (icon != null) {
                Label iconLabel = new Label(parent, 0);
                iconLabel.setImage(icon);
                iconLabel.setBackground(parent.getDisplay().getSystemColor(29));
                iconLabel.setData((Object)new GridData());
            }
            Text texts = new Text(parent, 522);
            if (icon == null) {
                GridDataFactory.generate((Control)texts, (int)2, (int)1);
            }
            texts.setText(text);
            texts.setBackground(parent.getDisplay().getSystemColor(29));
            return texts;
        }

        protected void addContent(Composite destination, Object modelElement) {
        }
    }

    public class SessionContextProjectTracker
    extends HintTracker {
        public SessionContextProjectTracker() {
            HintListenerAdapter activeProjectListener = new HintListenerAdapter(){

                public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                    StagingView.this.applySessionContext(StagingView.this.getSessionContext());
                }
            };
            this.addKeyHintListener(ProjectKeys.KEY_PROJECT, (IHintListener)activeProjectListener);
        }
    }
}

