/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.team.internal.Images;
import org.simantics.team.ui.TreeElement;

class ResourceElement
extends TreeElement {
    private Session session;
    private String resourceUri;
    private String resourceName;
    private Resource resource;

    ResourceElement(Session session, String resource) {
        this.session = session;
        this.resourceUri = resource;
    }

    ResourceElement(Session session, Resource resource) {
        this.session = session;
        this.resource = resource;
    }

    @Override
    protected Image getIdImage() {
        return Images.getInstance().RESOURCE_IMAGE;
    }

    @Override
    protected String getIdText() {
        String s = this.resource.toString();
        return s.substring(0, Math.min(10, s.length()));
    }

    private String getNameByUri() {
        try {
            String t = (String)this.session.syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph g) throws DatabaseException {
                    Set types;
                    ResourceElement.this.resource = g.getResource(ResourceElement.this.resourceUri);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)g);
                    ResourceElement.this.resourceName = (String)g.getPossibleRelatedValue(ResourceElement.this.resource, l0.HasName, (Binding)Bindings.STRING);
                    if (ResourceElement.this.resourceName == null && (types = g.getTypes(ResourceElement.this.resource)).size() > 0) {
                        Iterator i = types.iterator();
                        Resource r = (Resource)i.next();
                        ResourceElement.this.resourceName = (String)g.getPossibleRelatedValue(r, l0.HasName, (Binding)Bindings.STRING);
                    }
                    if (ResourceElement.this.resourceName == null) {
                        ResourceElement.this.resourceName = ResourceElement.this.resourceUri;
                    }
                    return ResourceElement.this.resourceName;
                }
            });
            return t;
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    private String getName() {
        try {
            String t = (String)this.session.syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph g) throws DatabaseException {
                    Set types;
                    Layer0 l0 = Layer0.getInstance((ReadGraph)g);
                    ResourceElement.this.resourceName = (String)g.getPossibleRelatedValue(ResourceElement.this.resource, l0.HasName, (Binding)Bindings.STRING);
                    if (ResourceElement.this.resourceName == null && (types = g.getTypes(ResourceElement.this.resource)).size() > 0) {
                        Iterator i = types.iterator();
                        Resource r = (Resource)i.next();
                        ResourceElement.this.resourceName = (String)g.getPossibleRelatedValue(r, l0.HasName, (Binding)Bindings.STRING);
                    }
                    if (ResourceElement.this.resourceName == null) {
                        ResourceElement.this.resourceName = ResourceElement.this.resourceUri;
                    }
                    return ResourceElement.this.resourceName;
                }
            });
            return t;
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    private Resource getParent() {
        try {
            Resource parent = (Resource)this.session.syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph g) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)g);
                    return g.getPossibleObject(ResourceElement.this.resource, l0.PartOf);
                }
            });
            return parent;
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    public String toString() {
        if (this.resourceName == null && this.resourceUri != null) {
            return this.getNameByUri();
        }
        if (this.resource != null && this.resourceUri == null) {
            return this.getName();
        }
        return this.resourceName;
    }

    @Override
    boolean hasChildren() {
        Resource p = this.getParent();
        return p != null;
    }

    @Override
    Object[] getChildren() {
        Resource p = this.getParent();
        if (p == null) {
            return new Object[0];
        }
        Object[] objects = new Object[]{new ResourceElement(this.session, p)};
        return objects;
    }
}

