/*******************************************************************************
 * Copyright (c) 2022 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2.variables;

import org.simantics.db.layer0.variable.Variable;

/**
 * A connection to nowhere that marks a connection relation to be not
 * synchronized to the solver at all.
 * 
 * @author Reino Ruusu
 * @since 1.51.0
 */
public class UndefinedConnection extends FixedConnection {

    public UndefinedConnection(Variable procedural) {
        super(procedural);
    }

    @Override
    public boolean isUndefined() {
        return true;
    }
}
