/*******************************************************************************
 * Copyright (c) 2022 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2.procedural;

import org.simantics.db.Resource;

/**
 * An undefined property that provides no value, but marks the property to be
 * ignored in solver synchronization.
 * 
 * @author Reino Ruusu
 * @since 1.51.0
 */
public class UndefinedProperty extends Property {

	public UndefinedProperty(Resource relation) {
		super(relation, null);
	}
}
