/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.Functions.InterfaceResolution;

public class DefinedUCInterfaceMap extends ResourceRead<Collection<InterfaceResolution>> {

    public DefinedUCInterfaceMap(Resource resource) {
        super(resource);
    }

    @Override
    public Collection<InterfaceResolution> perform(ReadGraph graph)
            throws DatabaseException {

        StructuralResource2 STR = StructuralResource2.getInstance(graph);
        Resource definition = graph.getPossibleObject(resource, STR.IsDefinedBy);
        if(definition != null) {
            Collection<InterfaceResolution> result = new ArrayList<>();
            Layer0 L0 = Layer0.getInstance(graph);
            for(Resource cp : graph.syncRequest(new ObjectsWithType(resource, L0.ConsistsOf, STR.ConnectionRelation))) {
                String cpName = graph.getRelatedValue(cp, L0.HasName, Bindings.STRING);
                for(Resource conn : graph.getObjects(cp, STR.IsBoundBy)) {
                    for(Statement stm : graph.getStatements(conn, STR.Connects)) {
                        Resource component = stm.getObject();
                        String componentName = graph.getRelatedValue(component, L0.HasName, Bindings.STRING);
                        result.add(new InterfaceResolution(cp, cpName, componentName, graph.getInverse(stm.getPredicate())));
                    }
                }
            }
            return result;
        }
        return null;
    }

}
