/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.ui.menuContributions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PreferenceCheckBoxAction
extends Action
implements IPropertyChangeListener {
    protected String preferenceKey;
    protected IPreferenceStore preferenceStore;

    public PreferenceCheckBoxAction(String name, String preferenceKey, IPreferenceStore preferenceStore) {
        super(name, 2);
        this.preferenceKey = preferenceKey;
        this.preferenceStore = preferenceStore;
        this.setToolTipText(name);
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.update();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(this.getKey())) {
            this.update();
        }
    }

    protected String getKey() {
        return this.preferenceKey;
    }

    private void update() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getBoolean(this.getKey())) {
            this.setChecked(true);
        } else {
            this.setChecked(false);
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void run() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean show = this.isChecked();
        store.removePropertyChangeListener((IPropertyChangeListener)this);
        store.setValue(this.getKey(), show);
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

