/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.solver;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.AbstractLongList;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.simulator.toolkit.StandardNodeManagerSupport;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.simantics.spreadsheet.ExternalRef;
import org.simantics.spreadsheet.SpreadsheetCellStyle;
import org.simantics.spreadsheet.SpreadsheetVisitor;
import org.simantics.spreadsheet.solver.ExternalRefConstant;
import org.simantics.spreadsheet.solver.ExternalRefData;
import org.simantics.spreadsheet.solver.SheetLineComponent;
import org.simantics.spreadsheet.solver.SheetNode;
import org.simantics.spreadsheet.solver.SpreadsheetCell;
import org.simantics.spreadsheet.solver.SpreadsheetCellContent;
import org.simantics.spreadsheet.solver.SpreadsheetCellContentExpression;
import org.simantics.spreadsheet.solver.SpreadsheetCellEditable;
import org.simantics.spreadsheet.solver.SpreadsheetElement;
import org.simantics.spreadsheet.solver.SpreadsheetEngine;
import org.simantics.spreadsheet.solver.SpreadsheetFormula;
import org.simantics.spreadsheet.solver.SpreadsheetLine;
import org.simantics.spreadsheet.solver.SpreadsheetLines;
import org.simantics.spreadsheet.solver.SpreadsheetMapping;
import org.simantics.spreadsheet.solver.SpreadsheetSCLConstant;
import org.simantics.spreadsheet.solver.SpreadsheetStyle;
import org.simantics.spreadsheet.solver.SpreadsheetTypeNode;
import org.simantics.spreadsheet.solver.formula.SpreadsheetEvaluationEnvironment;
import org.simantics.spreadsheet.synchronization.LineNodeUpdater;
import org.simantics.spreadsheet.synchronization.LineUpdater;
import org.simantics.spreadsheet.synchronization.NullUpdater;
import org.simantics.spreadsheet.synchronization.StyleUpdater;
import org.simantics.structural.synchronization.base.ModuleUpdaterBase;
import org.simantics.structural.synchronization.base.ModuleUpdaterFactoryBase;
import org.simantics.structural.synchronization.base.SolverNameUtil;
import org.simantics.structural.synchronization.utils.ComponentFactory;
import org.simantics.structural.synchronization.utils.MappingBase;
import org.simantics.structural.synchronization.utils.Solver;

public class SpreadsheetBook
implements StandardNodeManagerSupport<SheetNode>,
SpreadsheetElement<SpreadsheetElement, SpreadsheetElement>,
Serializable,
SheetNode<SpreadsheetEngine, SheetNode>,
Solver,
SolverNameUtil,
ComponentFactory<SheetLineComponent>,
ModuleUpdaterFactoryBase<SheetLineComponent> {
    private static final long serialVersionUID = 7417208688311691396L;
    public Serializable NotAvailableError = new Serializable(){
        private static final long serialVersionUID = 2535371785498129460L;
    };
    public Long2ObjectOpenHashMap<AbstractLongSet> referenceMap = new Long2ObjectOpenHashMap();
    private Int2ObjectArrayMap<SpreadsheetStyle> styles = new Int2ObjectArrayMap();
    public ArrayList<SpreadsheetEngine> sheets = new ArrayList();
    private SpreadsheetMapping mapping;
    String context;
    private int idCounter = 1;
    private transient boolean disposed = false;
    public Map<Integer, SpreadsheetElement> children = new HashMap<Integer, SpreadsheetElement>();
    private boolean iterationEnabled;
    static final int COMP_ROOT_POS = "COMP_ROOT/".length();
    static Variant DEFAULT_VALUE = Variant.ofInstance((Object)"Pending external reference");
    private Map<ExternalRef, ExternalRefData> externalRefMap = new HashMap<ExternalRef, ExternalRefData>();
    private transient ArrayList<SpreadsheetBookListener> listeners = new ArrayList();

    public SpreadsheetBook(String context) {
        this.getNewId(this);
        this.mapping = new SpreadsheetMapping(new SheetLineComponent(""));
        this.context = context;
    }

    public int getNewId(SpreadsheetElement element) {
        int result = this.idCounter++;
        this.children.put(result, element);
        return result;
    }

    public long getEngineIndex(SpreadsheetEngine engine) {
        int i = 0;
        while (i < this.sheets.size()) {
            if (this.sheets.get(i) == engine) {
                return i;
            }
            ++i;
        }
        throw new IllegalStateException("Did not find sheet " + engine.getName());
    }

    public void registerReferences(long cell, AbstractLongList refs) {
        int i = 0;
        while (i < refs.size()) {
            long key = refs.getLong(i);
            AbstractLongSet set = (AbstractLongSet)this.referenceMap.get(key);
            if (set == null) {
                set = new LongArraySet();
                this.referenceMap.put(key, (Object)set);
            }
            if (set.size() == 5) {
                LongLinkedOpenHashSet newSet = new LongLinkedOpenHashSet();
                newSet.addAll((LongCollection)set);
                set = newSet;
                this.referenceMap.put(key, (Object)set);
            }
            set.add(cell);
            ++i;
        }
    }

    public Binding getEngineBinding(SheetNode node) throws NodeManagerException {
        Object value = this.getEngineValue(node);
        if (value instanceof Variant) {
            return Bindings.VARIANT;
        }
        if (value instanceof String) {
            return Bindings.STRING;
        }
        if (value instanceof Boolean) {
            return Bindings.BOOLEAN;
        }
        if (value instanceof SpreadsheetStyle) {
            return SpreadsheetStyle.BINDING;
        }
        return Bindings.getBindingUnchecked(value.getClass());
    }

    public Object getEngineValue(SheetNode node) {
        if (node instanceof SpreadsheetCellContent) {
            try {
                SpreadsheetCellContent scc = (SpreadsheetCellContent)node;
                Object content = scc.cell.evaluate(SpreadsheetEvaluationEnvironment.getInstance(this));
                if (content == null) {
                    return Variant.ofInstance((Object)"");
                }
                if (content instanceof Variant) {
                    return content;
                }
                if (content instanceof ExternalRefData) {
                    return ((ExternalRefData)content).getContent();
                }
                return Variant.ofInstance(content);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return Variant.ofInstance((Object)t.toString());
            }
        }
        if (node instanceof SpreadsheetCellContentExpression) {
            SpreadsheetCellContentExpression scce = (SpreadsheetCellContentExpression)node;
            if (scce.cell.getContent() instanceof SpreadsheetFormula) {
                SpreadsheetFormula formula = (SpreadsheetFormula)scce.cell.getContent();
                return formula.expression;
            }
            if (scce.cell.getContent() instanceof SpreadsheetSCLConstant) {
                SpreadsheetSCLConstant sclConstant = (SpreadsheetSCLConstant)scce.cell.getContent();
                return "=" + sclConstant.getExpression();
            }
            System.out.println("Broken SpreadsheetCellContentExpression possibly due to overwriting an existing expression with a constant or something else (current content is " + scce.cell.getContent() + ")");
            if (scce.cell.getContent() instanceof Variant) {
                return scce.cell.getContent();
            }
            return Variant.ofInstance((Object)scce.cell.getContent());
        }
        if (node instanceof SpreadsheetTypeNode) {
            SpreadsheetTypeNode stn = (SpreadsheetTypeNode)node;
            return stn.uri;
        }
        if (node instanceof SpreadsheetCellStyle) {
            int styleId = ((SpreadsheetCellStyle)node).cell.style;
            SpreadsheetStyle style = this.getStyle(styleId);
            if (style == null) {
                style = SpreadsheetStyle.empty();
                if (styleId != style.getStyleId()) {
                    new Exception("different style ids!" + styleId + "  " + style.getStyleId()).printStackTrace();
                }
                this.addStyle(style);
            }
            return style;
        }
        if (node instanceof SpreadsheetCellEditable) {
            boolean editable = ((SpreadsheetCellEditable)node).editable();
            return editable;
        }
        return null;
    }

    public void setEngineValue(SheetNode node, Object value) {
        SpreadsheetCellContent scc = (SpreadsheetCellContent)node;
        Object content = scc.cell.evaluate(SpreadsheetEvaluationEnvironment.getInstance(this));
        System.err.println("content2: " + content);
        if (content instanceof Variant) {
            scc.cell.setContent(value);
        } else if (content instanceof ExternalRefData) {
            ExternalRefData erd = (ExternalRefData)content;
            erd.getRef().modify(this.context, (Variant)value);
        } else {
            throw new IllegalStateException("Unable to set cell value");
        }
    }

    public String getName(SheetNode node) {
        return node.getName();
    }

    public Map<String, SheetNode> getChildren(SheetNode node) {
        return node.getChildren();
    }

    public Map<String, SheetNode> getProperties(SheetNode node) {
        return node.getProperties();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public Map<String, SpreadsheetEngine> getChildren() {
        HashMap<String, SpreadsheetEngine> result = new HashMap<String, SpreadsheetEngine>();
        for (SpreadsheetEngine engine : this.sheets) {
            result.put(engine.getName(), engine);
        }
        return result;
    }

    @Override
    public Map<String, SheetNode> getProperties() {
        return Collections.emptyMap();
    }

    public SpreadsheetCell get(String sheet, int row, int column) {
        SpreadsheetEngine engine = this.getEngine(sheet);
        if (engine == null) {
            return null;
        }
        SpreadsheetLine line = engine.getLine(row);
        if (line == null) {
            return null;
        }
        if (line.cells.size() <= column) {
            return null;
        }
        return (SpreadsheetCell)line.cells.get(column);
    }

    public SpreadsheetCell get(SpreadsheetEngine engine, int row, int column) {
        SpreadsheetLine line = engine.getLine(row);
        if (line == null) {
            return null;
        }
        if (line.cells.size() <= column) {
            return null;
        }
        return (SpreadsheetCell)line.cells.get(column);
    }

    public SpreadsheetEngine getEngine(String sheet) {
        for (SpreadsheetEngine engine : this.sheets) {
            if (!sheet.equals(engine.getName())) continue;
            return engine;
        }
        return null;
    }

    public ModuleUpdaterBase<SheetLineComponent> createUpdater(String id) throws Exception {
        if ("http://www.simantics.org/Spreadsheet-1.2/Line".equals(id)) {
            return new LineUpdater(id);
        }
        if ("http://www.simantics.org/Spreadsheet-1.2/LineNode".equals(id)) {
            return new LineNodeUpdater(id);
        }
        if ("http://www.simantics.org/Spreadsheet-1.2/Style".equals(id)) {
            return new StyleUpdater(id);
        }
        if ("http://www.simantics.org/Spreadsheet-1.2/Lines".equals(id)) {
            return new NullUpdater(id);
        }
        if ("http://www.simantics.org/Spreadsheet-1.2/Spreadsheet".equals(id)) {
            return new NullUpdater(id);
        }
        if ("http://www.simantics.org/Spreadsheet-1.2/Book".equals(id)) {
            return new NullUpdater(id);
        }
        throw new IllegalStateException("createUpdater " + id);
    }

    public SheetLineComponent create(String uid) {
        return new SheetLineComponent(uid);
    }

    public String getFreshName(String parentName, String name) {
        return String.valueOf(parentName) + "/" + name;
    }

    public String ensureNameIsVariationOf(String parentName, int id, String name) {
        if (parentName.isEmpty()) {
            return name;
        }
        return String.valueOf(parentName) + "/" + name;
    }

    public int getId(String name) {
        if ("COMP_ROOT".equals(name)) {
            return 1;
        }
        String path = name.substring(COMP_ROOT_POS);
        Object[] parts = path.split("/");
        Object o = this.resolve((String[])parts, 0);
        if (o instanceof SpreadsheetLines) {
            return ((SpreadsheetLines)o).getId();
        }
        if (o instanceof SpreadsheetLine) {
            return ((SpreadsheetLine)o).getId();
        }
        if (o instanceof SpreadsheetEngine) {
            return ((SpreadsheetEngine)o).getId();
        }
        if (o instanceof SpreadsheetStyle) {
            return ((SpreadsheetStyle)o).getId();
        }
        throw new IllegalStateException("Resolved object for parts " + Arrays.toString(parts) + " is not the right type! It is " + o);
    }

    Object resolve(String[] parts, int index) {
        SpreadsheetEngine engine;
        String part = parts[index];
        if (part.startsWith("Style")) {
            for (SpreadsheetStyle style : this.styles.values()) {
                if (!style.name.equals(part)) continue;
                return style;
            }
        }
        if ((engine = this.getEngine(part)) == null) {
            return 0;
        }
        if (index == parts.length - 1) {
            return engine;
        }
        return engine.resolve(parts, index + 1);
    }

    public String getName(int id) {
        if (id == -2) {
            return "http://www.simantics.org/Spreadsheet-1.2/Book";
        }
        if (id == -3) {
            return "http://www.simantics.org/Spreadsheet-1.2/Spreadsheet";
        }
        if (id == -4) {
            return "http://www.simantics.org/Spreadsheet-1.2/Lines";
        }
        if (id == -5) {
            return "http://www.simantics.org/Spreadsheet-1.2/LineNode";
        }
        if (id == -6) {
            return "http://www.simantics.org/Spreadsheet-1.2/Line";
        }
        if (id == -7) {
            return "http://www.simantics.org/Spreadsheet-1.2/Style";
        }
        return "" + id;
    }

    public int getModuleType(int id) {
        Serializable s = this.children.get(id);
        if (s instanceof SpreadsheetBook) {
            return -2;
        }
        if (s instanceof SpreadsheetEngine) {
            return -3;
        }
        if (s instanceof SpreadsheetLines) {
            if ("Lines".equals(((SpreadsheetLines)s).getName())) {
                return -4;
            }
            return -5;
        }
        if (s instanceof SpreadsheetLine) {
            return -6;
        }
        if (s instanceof SpreadsheetStyle) {
            return -7;
        }
        throw new IllegalStateException();
    }

    @Override
    public void remove(int id) {
        SpreadsheetElement child = this.children.get(id);
        Optional parent = child.getParent();
        if (parent.isPresent()) {
            ((SpreadsheetElement)parent.get()).remove(child);
            this.children.remove(id);
        }
    }

    public void addSubprocess(String name, String subprocessType) {
        this.ensureSubprocess(name);
    }

    public <T> T ensureSubprocess(String name) {
        String[] parts = name.split("/");
        if (parts.length == 2) {
            SpreadsheetEngine engine = this.getEngine(parts[1]);
            if (engine == null) {
                engine = new SpreadsheetEngine(this, parts[1]);
                this.sheets.add(engine);
            }
            return (T)engine;
        }
        if (parts.length > 2) {
            SpreadsheetEngine engine = this.getEngine(parts[1]);
            return (T)engine.ensureSubprocess(parts, 2);
        }
        throw new IllegalStateException();
    }

    public void includeSubprocess(String parentName, String subprocessName) {
    }

    public <T> T getConcreteSolver() {
        return (T)this;
    }

    @Override
    public void accept(SpreadsheetVisitor v) {
        v.visit(this);
    }

    SpreadsheetCell cellByReferenceKey(long ref) {
        long sheet = ref >> 40;
        long row = ref >> 20 & 0xFFFFFL;
        long col = ref & 0xFFFFFL;
        return this.get(this.sheets.get((int)sheet), (int)row, (int)col);
    }

    public Set<SpreadsheetCell> invalidate(SpreadsheetCell cell) {
        HashSet<SpreadsheetCell> result = new HashSet<SpreadsheetCell>();
        result.add(cell);
        cell.invalidate();
        long refKey = cell.makeReferenceKey();
        AbstractLongSet refs = (AbstractLongSet)this.referenceMap.remove(refKey);
        if (refs == null) {
            return result;
        }
        Iterator iterator = refs.iterator();
        while (iterator.hasNext()) {
            long ref = (Long)iterator.next();
            SpreadsheetCell referer = this.cellByReferenceKey(ref);
            result.addAll(this.invalidate(referer));
        }
        return result;
    }

    @Deprecated
    public List<SpreadsheetCell> invalidateShallow(SpreadsheetCell cell) {
        ArrayList<SpreadsheetCell> result = new ArrayList<SpreadsheetCell>();
        result.add(cell);
        cell.invalidate();
        long refKey = cell.makeReferenceKey();
        AbstractLongSet refs = (AbstractLongSet)this.referenceMap.remove(refKey);
        if (refs == null) {
            return result;
        }
        Iterator iterator = refs.iterator();
        while (iterator.hasNext()) {
            long ref = (Long)iterator.next();
            SpreadsheetCell referer = this.cellByReferenceKey(ref);
            this.invalidate(referer);
            result.add(referer);
        }
        return result;
    }

    public void addStyle(SpreadsheetStyle style) {
        if (style.name == null) {
            new Exception("Trying to add style to book without name!!").printStackTrace();
            return;
        }
        style.setSynchronizationId(this.getNewId(style));
        this.styles.put(style.getStyleId(), (Object)style);
    }

    public SpreadsheetStyle getStyle(int styleId) {
        return (SpreadsheetStyle)this.styles.get(styleId);
    }

    public MappingBase<SheetLineComponent> getMapping() {
        return this.mapping;
    }

    @Override
    public Optional<SpreadsheetElement> getParent() {
        return Optional.empty();
    }

    @Override
    public Collection<SpreadsheetElement> getSpreadsheetChildren() {
        return this.children.values();
    }

    @Override
    public void remove(SpreadsheetElement child) {
    }

    public void setIterationEnabled(boolean value) {
        this.iterationEnabled = value;
    }

    public boolean isIterationEnabled() {
        return this.iterationEnabled;
    }

    void registerListening(long referenceKey, ExternalRef ref) {
        ExternalRefData data = this.externalRefMap.get(ref);
        if (data == null) {
            data = new ExternalRefData(this, referenceKey, ref);
            this.externalRefMap.put(ref, data);
        }
    }

    ExternalRefData getExternalRefValue(long referenceKey, ExternalRef ref) {
        ExternalRefData data = this.externalRefMap.get(ref);
        if (data == null) {
            this.registerListening(referenceKey, ref);
            return new ExternalRefData(this, referenceKey, new ExternalRefConstant(DEFAULT_VALUE));
        }
        return data;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void registerListener(SpreadsheetBookListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void fireChanges(Collection<SpreadsheetCell> cells) {
        for (SpreadsheetBookListener listener : this.listeners) {
            listener.cellsChanged(cells);
        }
    }

    public static interface SpreadsheetBookListener {
        public void cellsChanged(Collection<SpreadsheetCell> var1);
    }
}

