/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet;

import java.io.Serializable;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.formula.FormulaError2;

public class SpreadsheetMatrix
implements Serializable {
    private static final long serialVersionUID = 5729700370527844640L;
    private int w;
    private int h;
    public Object[] values;

    public SpreadsheetMatrix(int w, int h) {
        this.w = w;
        this.h = h;
        this.values = new Object[w * h];
    }

    public Object get(int row, int column) {
        return this.values[this.w * row + column];
    }

    public void set(int row, int column, Object value) {
        this.values[this.w * row + column] = value;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public double sum() {
        double result = 0.0;
        int i = 0;
        while (i < this.values.length) {
            Number n = Spreadsheets.asValidNumber(this.values[i]);
            if (n != null) {
                result += n.doubleValue();
            }
            ++i;
        }
        return result;
    }

    public Object sumWithFormulaError() {
        Double result = 0.0;
        int i = 0;
        while (i < this.values.length) {
            Object obj = this.values[i];
            if (obj != null) {
                FormulaError2 error = FormulaError2.forObject(obj);
                if (error != null) {
                    return error.getString();
                }
                Number n = Spreadsheets.asValidNumber(obj);
                if (n != null) {
                    result = result + n.doubleValue();
                }
            }
            ++i;
        }
        return result;
    }

    public Object maxWithFormulaError() {
        Double result = Double.MIN_VALUE;
        int i = 0;
        while (i < this.values.length) {
            Object obj = this.values[i];
            if (obj != null) {
                FormulaError2 error = FormulaError2.forObject(obj);
                if (error != null) {
                    return error.getString();
                }
                Number n = Spreadsheets.asValidNumber(obj);
                if (n != null && n.doubleValue() > result) {
                    result = n.doubleValue();
                }
            }
            ++i;
        }
        return result;
    }

    public Object minWithFormulaError() {
        Double result = Double.MAX_VALUE;
        int i = 0;
        while (i < this.values.length) {
            Object obj = this.values[i];
            if (obj != null) {
                FormulaError2 error = FormulaError2.forObject(obj);
                if (error != null) {
                    return error.getString();
                }
                Number n = Spreadsheets.asValidNumber(obj);
                if (n != null && n.doubleValue() < result) {
                    result = n.doubleValue();
                }
            }
            ++i;
        }
        return result;
    }

    public double average() {
        double result = 0.0;
        double count = 0.0;
        int i = 0;
        while (i < this.values.length) {
            Number n = Spreadsheets.asValidNumber(this.values[i]);
            if (n != null) {
                result += n.doubleValue();
                count += 1.0;
            }
            ++i;
        }
        if (count == 0.0) {
            return result;
        }
        return result / count;
    }

    public double countOfActualDoubleValues() {
        double count = 0.0;
        int i = 0;
        while (i < this.values.length) {
            Number n = Spreadsheets.asValidNumber(this.values[i]);
            if (n != null) {
                count += 1.0;
            }
            ++i;
        }
        return count;
    }

    public Object productWithFormulaError() {
        Double result = 1.0;
        boolean atLeastOne = false;
        int i = 0;
        while (i < this.values.length) {
            Object obj = this.values[i];
            if (obj != null) {
                FormulaError2 error = FormulaError2.forObject(obj);
                if (error != null) {
                    return error.getString();
                }
                Number n = Spreadsheets.asValidNumber(this.values[i]);
                if (n != null) {
                    double dval = n.doubleValue();
                    if (dval <= 0.0) {
                        return FormulaError2.NUM.getString();
                    }
                    result = result * dval;
                    atLeastOne = true;
                }
            }
            ++i;
        }
        if (atLeastOne) {
            return result;
        }
        return 0.0;
    }

    public SpreadsheetMatrix pow(Object exponent_) {
        if (exponent_ instanceof SpreadsheetMatrix) {
            SpreadsheetMatrix exponent = (SpreadsheetMatrix)exponent_;
            SpreadsheetMatrix result = new SpreadsheetMatrix(exponent.w, this.h);
            int i = 0;
            while (i < this.h) {
                int j = 0;
                while (j < exponent.w) {
                    result.set(i, j, Math.pow(Spreadsheets.asNumber(this.get(i, 0)), Spreadsheets.asNumber(exponent.get(0, j))));
                    ++j;
                }
                ++i;
            }
            return result;
        }
        double n = Spreadsheets.asNumber(exponent_);
        SpreadsheetMatrix result = new SpreadsheetMatrix(this.w, this.h);
        int i = 0;
        while (i < result.values.length) {
            result.values[i] = Math.pow(Spreadsheets.asNumber(this.values[i]), n);
            ++i;
        }
        return result;
    }
}

