package org.simantics.spreadsheet.ui.editor;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.Label;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableSpaceManipulator;
import org.simantics.db.layer0.variable.VariableSpaceManipulator.ChildCreationData;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.layer0.variable.VariableSpaceManipulator.Modification;
import org.simantics.db.layer0.variable.VariableSpaceManipulator.PropertyCreationData;
import org.simantics.db.management.ISessionContext;
import org.simantics.selectionview.PropertyTabContributorImpl;

public class NoCellTab extends PropertyTabContributorImpl {

	static class NoCellInput {
		
		public Variable sheet;
		public String location;
		
		public NoCellInput(Variable sheet, String location) {
			this.sheet = sheet;
			this.location = location;
		}
		
	}
	
    public void createControls(Composite body, IWorkbenchSite site, final ISessionContext context, WidgetSupport support) {

        Display display = body.getDisplay();
        Font font = new Font(display, "Arial", 12, SWT.NONE); 

    	Composite composite = new Composite(body, SWT.NONE);
        composite.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().grab(true, true).applyTo(composite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(2).applyTo(composite);
    	
        Composite headerComposite = new Composite(composite, 0);
        headerComposite.setBackground(display.getSystemColor(SWT.COLOR_BLACK));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo(headerComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(1).extendedMargins(2,2,2,2).applyTo(headerComposite);

        Composite headerComposite2 = new Composite(headerComposite, 0);
        headerComposite2.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo(headerComposite2);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(1).extendedMargins(3,3,3,3).applyTo(headerComposite2);

        Label header = new Label(headerComposite2, support, 0);
        header.setText("Create new cell");
        header.setFont(font);
        header.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(SWT.CENTER, SWT.CENTER).applyTo(header.getWidget());
        
    	Label label = new Label(composite, support, SWT.NONE);
    	label.setText("Expression: ");
        label.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().grab(false, false).applyTo(label.getWidget());
    	
        TrackedText name = new TrackedText(composite, support, SWT.BORDER);
        name.setText("");
        GridDataFactory.fillDefaults().grab(true, false).applyTo(name.getWidget());
        name.addModifyListener(new TextModifyListenerImpl<NoCellInput>() {

			@Override
			public void applyText(WriteGraph graph, NoCellInput input, String text) throws DatabaseException {
//				System.out.println("create variable for " + input);
				VariableSpaceManipulator manipulator = input.sheet.adapt(graph, VariableSpaceManipulator.class);
				manipulator.apply(graph, Modification.addChild(ChildCreationData.build(input.location, "", PropertyCreationData.build(Variables.NAME, text))));
			}
        	
        });
        
    }
   
}
