package org.simantics.spreadsheet.ui.editor;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.IContributedContentsView;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.Label;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.VariableStringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.VariableStringPropertyTextModifier;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.management.ISessionContext;
import org.simantics.selectionview.PropertyTabContributorImpl;
import org.simantics.spreadsheet.CommandCellExecutor;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.graph.GraphUI;

public class CommandCellTab extends PropertyTabContributorImpl {

    private IWorkbenchPart getContributor(IWorkbenchSite site) {
        IWorkbenchPage page = site.getPage();
        if (null == page)
            return null;
        return page.getActivePart();
    }
	
    public void createControls(Composite body, final IWorkbenchSite site, final ISessionContext context, WidgetSupport support) {

        Display display = body.getDisplay();
        Font font = new Font(display, "Arial", 12, SWT.NONE); 

    	Composite composite = new Composite(body, SWT.NONE);
        composite.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().grab(true, true).applyTo(composite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(2).applyTo(composite);
    	
        Composite headerComposite = new Composite(composite, 0);
        headerComposite.setBackground(display.getSystemColor(SWT.COLOR_BLACK));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo(headerComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(1).extendedMargins(2,2,2,2).applyTo(headerComposite);

        Composite headerComposite2 = new Composite(headerComposite, 0);
        headerComposite2.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo(headerComposite2);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(1).extendedMargins(3,3,3,3).applyTo(headerComposite2);

        Label header = new Label(headerComposite2, support, 0);
        //header.setTextFactory(new VariableStringPropertyFactory(" Variable - %1", "#URI"));
        header.setText("Command");
        header.setFont(font);
        header.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(SWT.CENTER, SWT.CENTER).applyTo(header.getWidget());
        
    	Label label = new Label(composite, support, SWT.NONE);
    	label.setText("Expression: ");
        label.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().grab(false, false).applyTo(label.getWidget());
    	
        TrackedText name = new TrackedText(composite, support, SWT.BORDER);
        name.setTextFactory(new VariableStringPropertyFactory("#Expression"));
        name.addModifyListener(new VariableStringPropertyTextModifier("Expression"));
        GridDataFactory.fillDefaults().grab(true, false).applyTo(name.getWidget());
        
        Button toggleCaseButton = new Button(composite, support, SWT.PUSH);
        toggleCaseButton.setText("Execute");
        toggleCaseButton.addSelectionListener(new SelectionListenerImpl<Variable>(context) {

			@Override
			public void apply(WriteGraph graph, Variable variable) throws DatabaseException {
				
		        final IWorkbenchPart spp = getContributor(site);
		        System.out.println("run command " + spp);
		        if(spp instanceof IContributedContentsView) {
		        	IContributedContentsView ccw = (IContributedContentsView)spp;
		        	IWorkbenchPart editorPart = ccw.getContributingPart();
		        	GraphUI ui = (GraphUI)editorPart.getAdapter(GraphUI.class);
		        	if(ui != null) {
		        		CommandCellExecutor executor = (CommandCellExecutor)ui.getAdapter(CommandCellExecutor.class);
		        		String location = variable.getPossiblePropertyValue(graph, "HasName");
		        		Range range = Spreadsheets.decodeCellAbsolute(location);
		        		executor.execute(range.startRow, range.startColumn);
				        System.out.println("uiui");
		        	}
		       
		        }
				
			}
			
		});
        
    }
   
}
