/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.ui;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;

import javax.swing.JTable;

import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.ClientModel;

public class TableDropTargetListener implements java.awt.dnd.DropTargetListener {

    JTable table;
    Adaptable model;
    ClientModel clientModel;

    public TableDropTargetListener(JTable table, Adaptable model, ClientModel clientModel) {
        this.table = table;
        this.model = model;
        this.clientModel = clientModel;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        // Setup positioning info for auto-scrolling
//    top = Math.abs(getLocation().y);
//    bottom = top + getParent().getHeight();
//    topRow = getClosestRowForLocation(0, top);
//    bottomRow = getClosestRowForLocation(0, bottom);
//    insets = new Insets(top + 10, 0, bottom - 10, getWidth());
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public synchronized void drop(final DropTargetDropEvent dropTargetDropEvent) {

        Transferable tr = dropTargetDropEvent.getTransferable();

        if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {

            try {

                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());

                String data = (String) tr.getTransferData(DataFlavor.stringFlavor);

                Point point = dropTargetDropEvent.getLocation();
                int row = table.rowAtPoint(point);
                int column = table.columnAtPoint(point);
                
                CellEditor e = (CellEditor)model.getAdapter(CellEditor.class);
                TextTableCellEditor editor = new TextTableCellEditor(row, column, "", e, clientModel);
                editor.commit();

            } catch (UnsupportedFlavorException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (IllegalArgumentException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

        }

    }

}